      PROGRAM  taffmerge
c
c...Merge ACRS And PPM Error Estimators After Taff-o-Gram
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1000
      INTEGER
     *         inacrs(NMAX), inppm(NMAX), i
      REAL
     *         xacrs(NMAX), yacrs(NMAX), xppm(NMAX), yppm(NMAX), x, y
c
 9001 FORMAT (i5, 6x, 2f6.0)
 9002 FORMAT (i3, 4f10.2)
c
c...Initialize
c
  100 DO i=1,NMAX
        inacrs(i) = 0
        inppm(i) = 0
      ENDDO
c
c...Read ACRS
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='uj10log.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) i,x,y
      inacrs(i) = 1
      xacrs(i) = x
      yacrs(i) = y
      GO TO 110
  120 CLOSE (1)
c
c...Read PPM
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='uj10ppm.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  130 READ (1,9001,end=140) i,x,y
      inppm(i) = 1
      xppm(i) = x
      yppm(i) = y
      GO TO 130
  140 CLOSE (1)
c
c...Write Merged File
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='uj10merge.out',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,NMAX
        IF ((inacrs(i).ne.0).and.(inppm(i).ne.0)) THEN
          WRITE (1,9002) i,xacrs(i),yacrs(i),xppm(i),yppm(i)
        ENDIF
      ENDDO
      CALL EXIT
      END
