      SUBROUTINE  itera(fatal,manual)
c
c...Iterate In A Small Region
c
      INCLUDE
     *            'geproc.inc'
      INTEGER
     *            i, err, fatal, manual
c
 9001 FORMAT (' N=', i7, '   SigmaX=', f6.2, '   SigmaY=', f6.2)
 9002 FORMAT (' X(', i2, ')=', 1pe14.7, '+/-', 1pe9.3,
     *      '   Y(', i2, ')=', 1pe14.7, '+/-', 1pe9.3)
 9005 FORMAT (' SubArea Processing Loop')
 9006 FORMAT (' SubArea Processing Failed')
 9007 FORMAT (' Fatal Error In Smallfit')
 9008 FORMAT (' Fatal Error In Smallfind')
c
c...Look In SubAreas
c
  100 WRITE (*,9005)
      CALL autoext(err,manual)
      IF (err.ne.0) THEN
        WRITE (*,9006)
        fatal = 4
        RETURN
      ENDIF
c
c...Iterate Once
c
      CALL smallxform
      WRITE (*,9001) npair,sigmax,sigmay
      DO i=1,ncoef
        WRITE (*,9002) i,xcoef(i),sxcoef(i),i,ycoef(i),sycoef(i)
      ENDDO
      CALL smallfind(fatal)
      IF (fatal.ne.0) THEN
        WRITE (*,9008)
        RETURN
      ENDIF
      CALL smallfit(x1p, xcoef,sxcoef,sigmax,err)
      IF (err.ne.0) THEN
        WRITE (*,9007)
        fatal = 5
        RETURN
      ENDIF
      CALL smallfit(y1p, ycoef,sycoef,sigmay,err)
      IF (err.ne.0) THEN
        WRITE (*,9007)
        fatal = 6
        RETURN
      ENDIF
      sigmax = 0.01D00*sigmax
      sigmay = 0.01D00*sigmay
      WRITE (*,9001) npair,sigmax,sigmay
      DO i=1,ncoef
        WRITE (*,9002) i,xcoef(i),sxcoef(i),i,ycoef(i),sycoef(i)
      ENDDO
      RETURN
      END
