      SUBROUTINE  radtrim(err)
c
c...Trim Radial Outliers
c
      INCLUDE
     *            'geproc.inc'
      INTEGER
     *            err, i, j, hist(5)
      DOUBLE PRECISION
     *            x, y, sx, sy, sn, sxx, syy, r, rsig
c
 9001 FORMAT ('SigX=', f10.1, '   SigY=', f10.1, '   SigR=', f10.1)
 9002 FORMAT (' Bins=', 5i10)
 9003 FORMAT (' Sigmas To Chop (NULL=NoChop): ' $)
 9004 FORMAT (f10.0)
 9005 FORMAT (' NPair=', i6)
c
c...Get Mean and Sigma
c
  100 sx = 0.0D00
      sy = 0.0D00
      sn = 0.0D00
      sxx = 0.0D00
      syy = 0.0D00
      DO i=1,npair
        x = x1(pair1(i))
        y = y1(pair1(i))
        sx = sx + x
        sy = sy + y
        sn = sn + 1.0
        sxx = sxx + x*x
        syy = syy + y*y
      ENDDO
      sx = sx/sn
      sy = sy/sn
      sxx = SQRT(sxx/sn - sx*sx)
      syy = SQRT(syy/sn - sy*sy)
      rsig = SQRT(sxx*sxx + syy*syy)
      x = 0.01D00*sxx
      y = 0.01D00*syy
      r = 0.01D00*rsig
      WRITE (*,9001) x,y,r
c
c...Compute Simple Histogram Of Radii
c
      DO i=1,5
        hist(i) = 0
      ENDDO
      DO i=1,npair
        x = x1(pair1(i))-sx
        y = y1(pair1(i))-sy
        r = SQRT(x*x+y*y)
        j = r/rsig
        IF (j.le.3) THEN
          hist(j+1) = hist(j+1)+1
        ELSE
          hist(5) = hist(5)+1
        ENDIF
      ENDDO
      WRITE (*,9002) (hist(i),i=1,5)
c
c...See What User Wants To Do
c
  110 WRITE (*,9003)
      READ  (*,9004,err=110,end=200) r
      IF (r.le.0.0) THEN
        err = 0
        RETURN
      ENDIF
      rsig = r*rsig
      j = 0
      DO i=1,npair
        x = x1(pair1(i))-sx
        y = y1(pair1(i))-sy
        r = SQRT(x*x+y*y)
        IF (r.le.rsig) THEN
          j = j+1
          pair1(j) = pair1(i)
          pair2(j) = pair2(i)
        ENDIF
      ENDDO
      npair = j
      WRITE (*,9005) npair
c
c...Compute New Fits Before Return
c
      CALL pairfit(x1, xcoef,sxcoef,sigmax,err)
      IF (err.ne.0) RETURN
      CALL pairfit(y1, ycoef,sycoef,sigmay,err)
      IF (err.ne.0) RETURN
      sigmax = 0.01D00*sigmax
      sigmay = 0.01D00*sigmay
      err = 0
      RETURN
c
c..Exit
c
  200 CALL EXIT
      END
