      SUBROUTINE  mergefind
c
c...Look In Sorted Lists For Pairs
c
      INCLUDE
     *            'jfoeproc.inc'
      PARAMETER
     *            npmax = 100
      INTEGER
     *            get, low, high, r, xl, xh, nfind, x, y,
     *            ifind(NPMAX), jfind(NPMAX), test, yl, yh, yt, j,
     *            n1, n2
      DOUBLE PRECISION
     *            dx, dy, dr, rfind(NPMAX), z, rsqr
c
c...Initialization
c
  100 get = 0
      npover = 0
      low = 1
      high = 1
      r = rmicron(3)*100.0D00 + 0.5D00
      rsqr = (r/SCALE)**2
      n1 = nmean(1)
      n2 = nmean(2)
      DO j=1,n2
        tmp(j) = 1
      ENDDO
c
c...Outer Loop Over W1 Index
c
  110 get = get+1
      IF (get.gt.n1) THEN
        RETURN
      ENDIF
      x = xmean(get,1)
      xl = x-r
      xh = x+r
      y = ymean(get,1)
      yl = y-r
      yh = y+r
c
c...Inner Loop Brackets W2
c
  120 CONTINUE
      IF (xhat(low).lt.xl) THEN
        IF (low.lt.n2) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (xhat(low).gt.xh) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 CONTINUE
      IF (high.lt.n2) THEN
        IF (xhat(high+1).le.xh) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Test All Unique Entries In This Range
c
      nfind = 0
      DO test=low,high
        IF (tmp(test).ne.0) THEN
          yt = yhat(test)
          IF ((yt.ge.yl).and.(yt.le.yh)) THEN
            dy = ((yt-y)/SCALE)**2
            IF (dy.le.rsqr) THEN
              dx = ((xhat(test)-x)/SCALE)**2
              dr = dx+dy
              IF (dr.le.rsqr) THEN
                IF (nfind.lt.NPMAX) THEN
                  nfind = nfind+1
                  ifind(nfind) = get
                  jfind(nfind) = test
                  rfind(nfind) = dr
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Save Pairs
c
      IF (nfind.gt.0) THEN
        j = 1
        z = rfind(j)
        DO test=2,nfind
          IF (rfind(test).lt.z) THEN
            j = test
            z = rfind(j)
          ENDIF
        ENDDO
        npover = npover+1
        pover1(npover) = ifind(j)
        pover2(npover) = idx(jfind(j))
        tmp(jfind(j)) = 0
      ENDIF
c
c...Loop Until Completion.  RETURN Is On GET
c
      GO TO 110
      END
