      PROGRAM  plotlist
c
c...Plot LISTx For Debugging
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nsmax = 1000
      REAL
     *         x1(NSMAX), x2(NSMAX), y1(NSMAX), y2(NSMAX), m1(NSMAX),
     *         m2(NSMAX), x1min, x1max, y1min, y1max, x2min, x2max,
     *         y2min, y2max, x1mean, y1mean, x2mean, y2mean, wide, x, y,
     *         t0, t, SECNDS, w, z, x1wide, x2wide, y1wide, y2wide,
     *         xmin, xmax, ymin, ymax
      INTEGER
     *         i, nn, in(6)
c
 9001 FORMAT (6i12)
 9002 FORMAT (' Wide(', 3(f6.1,','), f6.1, '): ' $)
 9003 FORMAT (f10.0)
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='autoext.lis',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nn = 0
  110 READ (1,9001,end=120) (in(i),i=1,6)
      nn = nn+1
      x1(nn) = 0.00001*in(1)
      y1(nn) = 0.00001*in(2)
      m1(nn) = 0.01*in(3)
      x2(nn) = 0.00001*in(4)
      y2(nn) = 0.00001*in(5)
      m2(nn) = 0.01*in(6)
      IF (nn.eq.1) THEN
        x1min = x1(nn)
        x1max = x1min
        y1min = y1(nn)
        y1max = y1min
        x2min = x2(nn)
        x2max = x2min
        y2min = y2(nn)
        y2max = y2min
      ELSE
        x1min = MIN(x1min,x1(nn))
        x1max = MAX(x1max,x1(nn))
        y1min = MIN(y1min,y1(nn))
        y1max = MAX(y1max,y1(nn))
        x2min = MIN(x2min,x2(nn))
        x2max = MAX(x2max,x2(nn))
        y2min = MIN(y2min,y2(nn))
        y2max = MAX(y2max,y2(nn))
      ENDIF
      GO TO 110
  120 CLOSE (1)
      x1mean = 0.5*(x1min+x1max)
      x1wide = x1max-x1min
      y1mean = 0.5*(y1min+y1max)
      y1wide = y1max-y1min
      x2mean = 0.5*(x2min+x2max)
      x2wide = x2max-x2min
      y2mean = 0.5*(y2min+y2max)
      y2wide = y2max-y2min
      WRITE (*,9002) x1wide,y1wide,x2wide,y2wide
      READ  (*,9003) wide
c
c...Stroke Mongo
c
      xmin = x1mean - 0.5*wide
      xmax = x1mean + 0.5*wide
      ymin = y1mean - 0.5*wide
      ymax = y1mean + 0.5*wide
      CALL mgoinit
      CALL mgosetup(-7)
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgorelocate(xmin,ymin)
      CALL mgoputlabel(5,'List1',9)
      DO i=1,nn
        CALL mgorelocate(x1(i),y1(i))
        CALL mgoputlabel(1,'+',6)
      ENDDO
      CALL mgoprntplot(i)
c
      t0 = SECNDS(0.0)
  125 t = SECNDS(t0)
      IF (t.le.3.0) GO TO 125
c
      xmin = x2mean - 0.5*wide
      xmax = x2mean + 0.5*wide
      ymin = y2mean - 0.5*wide
      ymax = y2mean + 0.5*wide
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgorelocate(xmin,ymin)
      CALL mgoputlabel(5,'List2',9)
      DO i=1,nn
        CALL mgorelocate(x2(i),y2(i))
        CALL mgoputlabel(1,'+',6)
      ENDDO
      CALL mgoprntplot(i)
      CALL EXIT
      END
