      SUBROUTINE  mergefit(zz,zcoef,szcoef,sigmaz,err)
c
c...Least Squares Fit To Plate Constants From MEAN Arrays
c
      INCLUDE
     *            'joeproc.inc'
      DOUBLE PRECISION
     *            zcoef(*), szcoef(*), sigmaz, x, y, z, chisq, zc,
     *            zr, m, dv(NCMAX)
      INTEGER
     *            i, j, k, nn, zz(*), ising, err, nc, np
c
 9001 FORMAT (' Singular Matrix In MERGEFIT')
c
c...Initialization
c
  100 nc = ncoef(3)
      np = npover
      DO i=1,nc
        zlhs(i) = 0.0D00
        DO j=1,nc
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0
      sigmaz = SANITYTAG
      m = 0.0D00
c
c...Accumulation
c
      DO i=1,np
        j = pover2(i)
        x = xmean(j,2)/SCALE
        y = ymean(j,2)/SCALE
        z = zz(pover1(i))/SCALE
        CALL filldv(x,y,m,nc,dv)
        DO j=1,nc
          zlhs(j) = zlhs(j) + dv(j)*z
          DO k=1,nc
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(nc,ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        err = 1
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,nc
        zcoef(i) = 0.0D00
        DO j=1,nc
          zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,np
        j = pover2(i)
        x = xmean(j,2)/SCALE
        y = ymean(j,2)/SCALE
        z = zz(pover1(i))/SCALE
        CALL filldv(x,y,m,nc,dv)
        zc = 0.0D00
        DO j=1,nc
          zc = zc + zcoef(j)*dv(j)
        ENDDO
        zr = z-zc
        chisq = chisq + zr*zr
      ENDDO
      sigmaz = SQRT(chisq/(np-(nc+1)))
c
c...Correct For Equal Weights
c
      sigmaz = sigmaz/SQRT(2.0D00)
c
c...Errors
c
      DO i=1,nc
        szcoef(i) = sigmaz*SQRT(zrhs(i,i))
      ENDDO
c
c...Convert To User's Units
c
      sigmaz = 0.01D00*SCALE*sigmaz
      err = 0
      RETURN
      END
