      PROGRAM  catbin
c
c...Produce A Binary Photometry Catalog
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         ncmax = 1000*1000,
     *         nbmax = 100,
     *         ncat = 2,
     *         circle = 100*3600*360,
     *         magtag = 9999
      CHARACTER*64
     *         lb
      CHARACTER*16
     *         id, catid(NCMAX)
      CHARACTER*7
     *         jd, badid(NBMAX)
      CHARACTER*6
     *         who
      DOUBLE PRECISION
     *         ra, dec, mag(6), radian, factor, offset,
     *         fx(15,10), fy(15,10), base, dx, dy, result
      INTEGER
     *         cra(NCMAX), cdec(NCMAX), nc, nb, i, nentry(10),
     *         idx(NCMAX), tmp(NCMAX), icat, nlb, jflag(10), j,
     *         jmag(NCMAX), fmag(NCMAX), nmag(NCMAX), isub(2,10),
     *         omag(NCMAX), emag(NCMAX), k, jj, indx, imag(5)
c
 9001 FORMAT (a, 27x, 2f12.0, 6f7.0)
 9002 FORMAT (a)
 9003 FORMAT (' Found ', i10, ' Bad Stars')
 9004 FORMAT (' Found ', i10, ' Catalog Stars')
 9005 FORMAT (i10)
 9006 FORMAT (' NS=', i10, ' After File ', a)
 9008 FORMAT (63x, a)
 9009 FORMAT (8x, 4i5)
 9010 FORMAT (2f7.3)
 9011 FORMAT (' CALCMAG Cannot Compute BASE ', 2i10)
c
c...Read Known Bad Entries
c
  100 CALL f_doenv('AUXUBV:badstar.txt',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nb = 0
  110 READ (1,9002,end=120) jd
      nb = nb+1
      badid(nb) = jd
      IF (nb.lt.NBMAX) GO TO 110
  120 CLOSE (1)
      WRITE (*,9003) nb
c
c...Load Magnitude Conversion Tables
c
      CALL f_doenv('AUXUBV:tables.txt',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,10
        READ (1,9009) nentry(i),(isub(j,i),j=1,2),jflag(i)
        DO j=1,nentry(i)
          READ (1,9010) fx(j,i),fy(j,i)
        ENDDO
      ENDDO
      CLOSE (1)
c
c...Other Initializations
c
      radian = 45.0D00/ATAN(1.0D00)
      factor = 100.0D00*3600.0D00*radian
      offset = 100.0D00*3600.0D00*90.0D00
      nc = 0
c
c...Coded As Loop For A Variety Of Catalogs
c
      DO icat=1,NCAT
        IF (icat.eq.1) THEN
          CALL f_doenv('AUXUBV:field.cat',nlb,lb)
        ELSE
          CALL f_doenv('AUXUBV:seq.cat',nlb,lb)
        ENDIF
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,9001)
        READ (1,9001)
c
c...Read And Parse Each Entry
c
  130   READ (1,9001,end=160) id,ra,dec,(mag(i),i=1,6)
        READ (1,9008) who
c
c...For some reasons, a few entries have V=0.00.  Reject them!
c
        IF (mag(1).eq.0.0D00) GO TO 130
c
c...Reject Known Bad Objects
c
        DO i=1,nb
          IF (id(2:8).eq.badid(i)) GO TO 130
        ENDDO
c
c...Reject Unwanted Standards
c
        IF (who.eq.'aps   ') GO TO 130
c
c...Compute And Reject Magnitudes
c
c	Order of  MAG() Is V, B-V, U-B, V-R, R-I, V-I
c	Order of IMAG() Is J, F, N, O, E
c
c	My version of AAH's CALCMAG.F
c
        DO k=1,5
          imag(k) = 0
          indx = k*2-1
          jj = 2
          IF  ((jflag(indx).gt.0)
     *    .and.(fx(1,indx).le.mag(jj))
     *    .and.(mag(jj).le.fx(nentry(indx),indx))) GO TO 140
          indx = k*2
          jj = 4
          IF  ((jflag(indx).gt.0)
     *    .and.(fx(1,indx).le.mag(jj))
     *    .and.(mag(jj).le.fx(nentry(indx),indx))) GO TO 140
          indx = k*2-1
          jj = 2
          IF  ((fx(1,indx).le.mag(jj))
     *    .and.(mag(jj).le.fx(nentry(indx),indx))) GO TO 140
          indx = k*2
          jj = 4
          IF  ((fx(1,indx).le.mag(jj))
     *    .and.(mag(jj).le.fx(nentry(indx),indx))) GO TO 140
          imag(k) = MAGTAG
  140     IF (imag(k).ne.MAGTAG) THEN
c
c...AAH's CALCMAG that I borrowed has a bug near here.  There are
c	2 combinations with ISUB(2,indx)!=0 in TABLES.TXT.
c
c	ISUB(1,indx)	ISUB(2,indx)	Col.1	Col.2
c	  1		  4		V-R	F-R
c	  1		  4		V-R	N-R
c	  1		  4		V-R	E-R
c	  2		  1		B-V	O-B
c
c	AAH's code always takes the (-) sign.
c
            IF (isub(2,indx).eq.0) THEN
              base = mag(isub(1,indx))
            ELSE
              IF (isub(1,indx).eq.2) THEN
                base = mag(isub(1,indx))+mag(isub(2,indx))
              ELSE
                base = mag(isub(1,indx))-mag(isub(2,indx))
              ENDIF
            ENDIF
            DO i=1,nentry(indx)-1
              IF  ((mag(jj).ge.fx(i  ,indx))
     *        .and.(mag(jj).le.fx(i+1,indx))) THEN
                dx = fx(i+1,indx) - fx(i,indx)
                dy = fy(i+1,indx) - fy(i,indx)
                result = base + fx(i,indx)
     *                 + (mag(jj)-fx(i,indx))*dy/dx
                imag(k) = 100.0D00*result + 0.5D00
                GO TO 150
              ENDIF
            ENDDO
            imag(k) = MAGTAG
  150       CONTINUE
          ENDIF
        ENDDO
c
c...Compute RA/DEC and Save This Entry
c
        nc = nc+1
        i = ra*factor
        IF (i.lt.0) THEN
          i = i+CIRCLE
        ELSEIF (i.ge.CIRCLE) THEN
          i = MOD(i,circle)
        ENDIF
        cra(nc) = i
        i = dec*factor + offset
        IF (i.lt.0) THEN
          i = i+CIRCLE
        ELSEIF (i.ge.CIRCLE) THEN
          i = MOD(i,CIRCLE)
        ENDIF
        cdec(nc) = i
        jmag(nc) = imag(1)
        fmag(nc) = imag(2)
        nmag(nc) = imag(3)
        omag(nc) = imag(4)
        emag(nc) = imag(5)
        GO TO 130
  160   CLOSE (1)
        WRITE (*,9006) nc,lb(1:nlb)
      ENDDO
      WRITE (*,9004) nc
c
c...Sort On RA
c
      DO i=1,nc
        idx(i) = i
      ENDDO
      CALL iuqsrt(nc,cra,idx)
      CALL ireord(nc,idx,cdec,tmp)
      CALL ireord(nc,idx,jmag,tmp)
      CALL ireord(nc,idx,fmag,tmp)
      CALL ireord(nc,idx,nmag,tmp)
      CALL ireord(nc,idx,omag,tmp)
      CALL ireord(nc,idx,emag,tmp)
c
c...Save As INF/DAT Pair
c
      CALL f_doenv('AUXUBV:cat.inf',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9005) nc
      CLOSE (1)
      lb(nlb-2:nlb) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='delete',
     *      err=170,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      recl=nc,
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      CLOSE(1)
  170 OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      recl=nc,
     *      recordtype='fixed',
     *      status='new',
     *      unit=1
     *     )
      WRITE (1,rec=1) (cra(i),i=1,nc)
      WRITE (1,rec=2) (cdec(i),i=1,nc)
      WRITE (1,rec=3) (jmag(i),i=1,nc)
      WRITE (1,rec=4) (fmag(i),i=1,nc)
      WRITE (1,rec=5) (nmag(i),i=1,nc)
      WRITE (1,rec=6) (omag(i),i=1,nc)
      WRITE (1,rec=7) (emag(i),i=1,nc)
      WRITE (1,rec=8) (idx(i),i=1,nc)
      CLOSE (1)
      CALL EXIT
      END
