      SUBROUTINE  eatp1
c
c...Ingest POSS1 Field Centers
c
      INCLUDE
     *            'centers.inc'
      DOUBLE PRECISION
     *            r1950, d1950, r2000, d2000
      CHARACTER*1
     *            dsign, who
      INTEGER
     *            rhh, rmm, rss, ddd, dmm, dss, i, field
c
 9001 FORMAT (i6, 23x, 3i2, 1x, a, 3i2, 26x, a)
c
c...Initialization
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uy6/xpmm/sg5/tycho/possi.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001)
      DO i=1,NMAX
        efind(i) = 0
        ofind(i) = 0
      ENDDO
c
c...Read Each Entry, Precess, And Save
c
  110 READ (1,9001,end=120) field,rhh,rmm,rss,dsign,ddd,dmm,dss,who
      IF ((field.lt.0).or.(field.gt.937)) GO TO 110
      r1950 = (rhh + rmm/60.0D00 + rss/3600.0D00)*twopi/24.0D00
      d1950 = (ddd + dmm/60.0D00 + dss/3600.0D00)*twopi/360.0D00
      IF (dsign.eq.'-') THEN
        d1950 = -d1950
      ENDIF
      CALL sla_FK45Z(r1950,d1950,1950.0D00,r2000,d2000)
      p1ra(field) = r2000*24.0D00/twopi
      p1dec(field) = d2000*360.0D00/twopi
      IF (who.eq.'O') THEN
        ofind(field) = 1
      ELSEIF (who.eq.'E') THEN
        efind(field) = 1
      ENDIF
      GO TO 110
  120 CLOSE (1)
      RETURN
      END
