      SUBROUTINE  magcheck
c
c...Check Magnitudes
c
      INCLUDE
     *            'check.inc'
      PARAMETER
     *            nhist = 20,
     *            nfract = 3,
     *            x2min =  15*1000*100,
     *            x2max = 335*1000*100,
     *            y2min =  15*1000*100,
     *            y2max = 335*1000*100
      INTEGER
     *            i, i1, i2, j, hist(NHIST), bright, faint, ok, nfind,
     *            find(NHIST), n, xin(2), yin(2), xout(2), yout(2)
      DOUBLE PRECISION
     *            z, sz, szz, fract(NFRACT), x, y, xhat, yhat, dv(NCMAX)
      DATA
     *   fract/0.68269D00, 0.95449D00, 0.9973002D00/,
     *    xin/X2MIN, X2MAX/,
     *    yin/Y2MIN, Y2MAX/
c
 9001 FORMAT (' GSC Historgram OK=', i5, '   Bright=', i5,
     *        '   Faint=', i5)
 9002 FORMAT (' MAGCHECK N=', i5, '  DeltaM=', f5.2, '+/-', f4.2)
 9003 FORMAT (' M=', i2, '  N(GSC)=', i5, '  N(paired)=', i5,
     *        3x, f5.1, '%')
 9004 FORMAT (' Sigma=', i1, '  Fract=', f5.3, '   N=', i5,
     *        '   Err=', f4.2)
 9005 FORMAT (' Sorted N=', i6)
c
c...Transform Corners Of (2) To Get Limits For (1)
c
  100 DO i=1,2
        x = xin(i)/SCALE
        y = yin(i)/SCALE
        xhat = 0.0D00
        yhat = 0.0D00
        dv( 1) = 1.0D00
        dv( 2) = x
        dv( 3) = y
        dv( 4) = x*x
        dv( 5) = x*y
        dv( 6) = y*y
        dv( 7) = x*x*x
        dv( 8) = x*x*y
        dv( 9) = x*y*y
        dv(10) = y*y*y
        DO j=1,nxform
          xhat = xhat + dv(j)*xform(j)
          yhat = yhat + dv(j)*yform(j)
        ENDDO
        xout(i) = xhat*SCALE
        yout(i) = yhat*SCALE
      ENDDO
      write (*,9991) xin(1),yin(1),xin(2),yin(2)
      write (*,9991) xout(1),yout(1),xout(2),yout(2)
 9991 format (7i11)
c
c...Histogram All Of (1)
c
      DO i=1,NHIST
        hist(i) = 0
        find(i) = 0
      ENDDO
      bright = 0
      faint = 0
      ok = 0
      nfind = 0
      DO i=1,n1
        tmp(i) = -1
        IF  ((x1(i).ge.xout(1)).and.(x1(i).le.xout(2))
     *  .and.(y1(i).ge.yout(1)).and.(y1(i).le.yout(2))) THEN
          j = m1(i)/100
          IF (j.lt.1) THEN
            bright = bright+1
          ELSEIF (j.gt.NHIST) THEN
            faint = faint+1
          ELSE
            ok = ok+1
            hist(j) = hist(j)+1
            tmp(i) = 0
          ENDIF
        ENDIF
      ENDDO
      WRITE (*,9001) ok,bright,faint
c
c...Examine The Pairs
c
      sz = 0.0D00
      szz = 0.0D00
      n = 0
      DO i=1,npover
        i1 = pover(i,1)
        i2 = pover(i,2)
        IF ((i1.gt.0).and.(i2.gt.0)) THEN
          IF (tmp(i1).eq.0) THEN
            z = 0.01D00*(m1(i1)-m2(i2))
            sz = sz + z
            szz = szz + z*z
            n = n+1
            tmp(i1) = 100.0D00*ABS(z) + 1
            j = m1(i1)/100
            IF ((j.ge.1).and.(j.le.NHIST)) THEN
              find(j) = find(j)+1
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      sz = sz/n
      szz = SQRT(szz/n - sz*sz)
      WRITE (*,9002) n,sz,szz
      n = 0
      DO i=1,n1
        IF (tmp(i).gt.0) THEN
          n = n+1
          tmp(n) = tmp(i)-1
        ENDIF
      ENDDO
      CALL juqsrt(n,tmp)
      WRITE (*,9005) n
      DO i=1,NFRACT
        j = fract(i)*n + 0.5D00
        z = 0.01D00*tmp(j)
        WRITE (*,9004) i,fract(i),j,z
      ENDDO
c
c...Compute Fraction Found In Each Bin
c
      DO i=1,NHIST
        IF (hist(i).gt.0) THEN
          sz = find(i)
          szz = hist(i)
          z = 100.0*sz/szz
          WRITE (*,9003) i,hist(i),find(i),z
        ENDIF
      ENDDO
      RETURN
      END
