      SUBROUTINE  docheck
c
c...Check Transformation
c
      INCLUDE
     *            'check.inc'
      PARAMETER
     *            nmag = 25,
     *            qmin = 2
      INTEGER
     *            i, i1, i2, inhist(0:9), outhist(0:9), j, nin, nout,
     *            nxin, nxout, min, mout, inmag(NMAG), outmag(NMAG), k
      DOUBLE PRECISION
     *            rx, ry, sx, sxx, sy, syy, sn, s
c
 9001 FORMAT (' DOCHECK X=', f8.1, '+/-', f8.1, '  Y=', f8.1, '+/-',
     *        f8.1, '  N=', i7)
 9002 FORMAT (8i10)
c
c...Initialization
c
  100 CALL xformpar(2,xtmp,ytmp)
      sx = 0.0D00
      sxx = 0.0D00
      sy = 0.0D00
      syy = 0.0D00
      sn = 0.0D00
      DO i=0,9
        inhist(i) = 0
        outhist(i) = 0
      ENDDO
      DO i=1,NMAG
        inmag(i) = 0
        outmag(i) = 0
      ENDDO
      nxin = 0
      nxout = 0
      j = limitmag(id)
      DO i=1,nraw(1)
        IF (ira(i).lt.0) THEN
          qtmp(i) = 1
        ELSE
          IF (mag(i).gt.j) THEN
            qtmp(i) = 4
          ELSE
            qtmp(i) = 0
          ENDIF
        ENDIF
      ENDDO
c
c...Count In/Out According To ROR
c
      min = 0
      mout = 0
      DO i1=1,nraw(1)
        IF (qtmp(i1).eq.0) THEN
          IF (qual(i1).ge.2) THEN
            min = min+1
          ELSE
            mout = mout+1
          ENDIF
        ENDIF
      ENDDO
c
c...Loop Over Pairs
c
      DO i=1,npover
        i1 = pover(i,1)
        i2 = pover(i,2)
        IF ((i1.gt.0).and.(i2.gt.0)) THEN
          rx = xraw(i1,1) - xtmp(i2)
          sx = sx + rx
          sxx = sxx + rx*rx
          ry = yraw(i1,1) - ytmp(i2)
          sy = sy + ry
          syy = syy + ry*ry
          sn = sn + 1.0D00
c
c...Histogram For ROR Stuff
c
          IF (qtmp(i1).eq.0) THEN
            j = qual(i1)
            inhist(j) = inhist(j)+1
            qtmp(i1) = 2
            IF (j.ge.QMIN) THEN
              k = mag(i1)/100
              IF ((k.ge.1).and.(k.le.NMAG)) THEN
                inmag(k) = inmag(k)+1
              ENDIF
            ENDIF
          ELSE
            nxin = nxin+1
          ENDIF
        ENDIF
      ENDDO
c
c...Loop Over Others
c
      DO i1=1,nraw(1)
        IF (qtmp(i1).eq.0) THEN
          j = qual(i1)
          outhist(j) = outhist(j)+1
          qtmp(i1) = 3
          IF (j.ge.QMIN) THEN
            k = mag(i1)/100
            IF ((k.ge.1).and.(k.le.NMAG)) THEN
              outmag(k) = outmag(k)+1
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Compute Statistics
c
      sx = sx/sn
      sxx = SQRT(sxx/sn - sx*sx)
      sy = sy/sn
      syy = SQRT(syy/sn - sy*sy)
      i = sn+0.5D00
c
c...Scale So As Not To Scare The User
c
      s = 0.01D00/SQRT(2.0D00)
      sx = sx*s
      sy = sy*s
      sxx = sxx*s
      syy = syy*s
      WRITE (*,9001) sx,sxx,sy,syy,i
c
c...Histogram Statistics
c
      nin = 0
      nout = 0
      DO i=0,9
        nin = nin + inhist(i)
        nout = nout + outhist(i)
      ENDDO
      WRITE (*,9002) npover,nraw(1),nin,nout,nxin,nxout,min,mout
      WRITE (3,9002) npover,nraw(1),nin,nout,nxin,nxout,min,mout
      DO i=0,9
        WRITE (*,9002) i,inhist(i),outhist(i)
        WRITE (3,9002) i,inhist(i),outhist(i)
      ENDDO
      nin = 0
      nout = 0
      DO i=1,NMAG
        nin = nin + inmag(i)
        nout = nout + outmag(i)
      ENDDO
      WRITE (*,9002) nin,nout
      WRITE (3,9002) nin,nout
      DO i=1,nmag
        WRITE (*,9002) i,inmag(i),outmag(i)
        WRITE (3,9002) i,inmag(i),outmag(i)
      ENDDO
      RETURN
      END
