      PROGRAM  p1corn
c
c...Make The CORNER File
c
      IMPLICIT
     *            NONE
      INCLUDE
     *            'p1corn.inc'
      PARAMETER
     *            delta = 6.5D00*25.4D00,
     *            scale = 67.18D00
      INTEGER
     *            i, id
      DOUBLE PRECISION
     *            rhh, rmm, rss, ddd, dmm, dss, r1950, d1950,
     *            r2000, d2000, radian, ra_to_rad, dec_to_rad,
     *            r0, d0, z, buf(10*NP1)
      CHARACTER*1
     *            dsign
c
 9001 FORMAT (i6, 23x, 3f2.0, 1x, a, 3f2.0)
c
c...Initialization
c
  100 radian = 45.0D00/ATAN(1.0D00)
      ra_to_rad = 15.0D00/radian
      dec_to_rad = 1.0D00/radian
c
c...Read Nominals.  These Are B1950
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uy6/xpmm/sg5/tycho/possi.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001)
      DO i=1,NP1
        READ (1,9001) id,rhh,rmm,rss,dsign,ddd,dmm,dss
        READ (1,9001)
        IF (id.ne.i) THEN
          STOP 'POSS-I Out Of Order'
        ENDIF
        d1950 = (ddd + dmm/60.0D00 + dss/3600.0D00)*dec_to_rad
        IF (dsign.eq.'+') THEN
          CONTINUE
        ELSEIF (dsign.eq.'-') THEN
          d1950 = -d1950
        ELSE
          STOP 'POSS-I DEC Parse Error'
        ENDIF
        r1950 = (rhh + rmm/60.0D00 + rss/3600.0D00)*ra_to_rad
        CALL sla_FK45Z(r1950,d1950,1950.0D00,r2000,d2000)
        p1ra(i) = r2000
        p1dec(i) = d2000
      ENDDO
      CLOSE (1)
c
c
c...Compute Corners
c
      DO i=1,NP1
        r0 = p1ra(i)
        d0 = p1dec(i)
        z = (DELTA*SCALE/3600.0D00)/radian
        CALL sla_DTP2S(-z,-z,r0,d0,p1rc(1,i),p1dc(1,i))
        CALL sla_DTP2S( z,-z,r0,d0,p1rc(2,i),p1dc(2,i))
        CALL sla_DTP2S(-z, z,r0,d0,p1rc(3,i),p1dc(3,i))
        CALL sla_DTP2S( z, z,r0,d0,p1rc(4,i),p1dc(4,i))
      ENDDO
c
c...Save It
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='p1corn.dat',
     *      recl=(20*NP1),
     *      recordtype='fixed',
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,rec=1) p1buf
      CLOSE (1)
      CALL EXIT
      END
