      SUBROUTINE  p1read
c
c...Read POSSI.CAT
c
      INCLUDE
     *            'possgsc.inc'
      CHARACTER*132
     *            lb, qb
      CHARACTER*7
     *            cplate, cdate, cdec
      CHARACTER*6
     *            cra, cfilt
      CHARACTER*5
     *            ctype, cha
      CHARACTER*4
     *            ctime
      CHARACTER*3
     *            mon, monlist(12)
      CHARACTER*2
     *            emul
      INTEGER
     *            nlb, nident, err, id, exp, mm, dd, yy, f, nqb,
     *            rah, ram, decd, decm, uthh, utmm, hah, ham,
     *            cyy, cdn, j
      DOUBLE PRECISION
     *            ra2000, dec2000, ra, dec, ut, ep, ras, decs, dist,
     *            mra, mdec, ha
      DATA
     *            monlist/'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *                    'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
c
 9001 FORMAT (i6)
 9002 FORMAT (q, a)
 9003 FORMAT (i6, 3(1x,a), 2x,a, 1x,a, 1x,2f10.0, 2(1x,a), 2x,i3,
     *        1x,a)
 9004 FORMAT (i2, a, i2)
 9005 FORMAT (2i2, f2.0)
 9006 FORMAT (2i2)
 9007 FORMAT (' POSSI.CAT Out Of Order', i10)
 9008 FORMAT (i1, 1x, i2, 1x)
 9009 FORMAT (' HA>>', a, '<<')
c
c...Look In Catalog
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possi.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002)
      DO f=1,NP1
        IF (f.le.937) THEN
          READ (1,9002) nlb,lb
        ENDIF
        READ (1,9002) nlb,lb
        READ (lb(1:6),9001) id
        IF (id.ne.f) THEN
          WRITE (*,9007) id
          CALL EXIT
        ENDIF
        READ (lb(1:nlb),9003) id,cplate,cdate,ctime,cra,cdec,
     *                        ra2000,dec2000,ctype,cfilt,exp,cha
        IF (f.le.937) THEN
          emul = 'SO'
        ELSE
          emul = 'SE'
        ENDIF
        IF (emul(2:2).ne.ctype(5:5)) THEN
          WRITE (*,9007) id
          CALL EXIT
        ENDIF
        READ (cdate,9004) dd,mon,yy
        yy = yy+1900
c
c...Parse Catalog Entry
c
        DO mm=1,12
          IF (monlist(mm).eq.mon) GO TO 110
        ENDDO
  110   READ (cra,9005) rah,ram,ras
        CALL sla_DTF2R(rah,ram,ras, ra,j)
        IF (j.ne.0) GO TO 200
        READ (cdec(2:7),9005) decd,decm,decs
        CALL sla_DAF2R(decd,decm,decs, dec,j)
        IF (j.ne.0) GO TO 200
        IF (INDEX(cdec,'-').gt.0) THEN
          dec = -dec
        ENDIF
        READ (ctime,9006) uthh,utmm
        ut = uthh + utmm/60.0D00 + exp/120.0D00
c
c...Precess To J2000 And Copy Into Common
c
        CALL sla_CALDJ(yy,mm,dd, p1djm(f),j)
        IF (j.ne.0) GO TO 200
        CALL sla_CALYD(yy,mm,dd, cyy,cdn,j)
        IF (j.ne.0) GO TO 200
        IF (MOD(yy,4).eq.0) THEN
          ep = cyy + (cdn + ut/24.0D00 - 1)/366.0D00
        ELSE
          ep = cyy + (cdn + ut/24.0D00 - 1)/365.0D00
        ENDIF
        p1ra(f) = ra
        p1dec(f) = dec
        CALL sla_PRECES('FK5',ep,2000.0D00,p1ra(f),p1dec(f))
        p1ut(f) = ut
        READ (cha,9008) hah,ham
        ha = hah + ham/60.0D00
        IF (cha(5:5).eq.'E') THEN
          ha = -ha
        ENDIF
        p1ha(f) = ha*15.0D00/radian
      ENDDO
      RETURN
c
c...Errors
c
  200 STOP 'P1READ SLA Error'
      END
