      SUBROUTINE  findlim(ff)
c
c...Look At NoTAFF Solution And Compute Limits
c
      INCLUDE
     *            'possgsc.inc'
      INTEGER
     *            ff, nlb, i, j, xin(4), yin(4), xx(4), yy(4)
      CHARACTER*64
     *            lb
      CHARACTER*1
     *            c
      DOUBLE PRECISION
     *            x, y, dv(NCMAX), xhat, yhat
      DATA
     *   xin/TOOSMALL, TOOSMALL, TOOBIG, TOOBIG/,
     *   yin/TOOSMALL, TOOBIG, TOOSMALL, TOOBIG/
c
 9001 FORMAT ('/uw6/xpmm/auxgsc', a, '/go', i4.4, '.fit')
 9002 FORMAT (' Cannot Open Old Fit File ', a)
 9003 FORMAT (i2, 2(1x,1pe15.8))
c
c...Read FIT File
c
  100 c = CHAR(ICHAR('0') + (ff/100))
      WRITE (lb,9001) c,ff
      nlb = 28
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003)
      READ (1,9003)
      READ (1,9003) ncoef
      DO i=1,ncoef
        READ (1,9003) j,xcoef(i),ycoef(i)
      ENDDO
      CLOSE (1)
c
c...Transform Corners
c
      DO i=1,4
        x = xin(i)/FACTOR
        y = yin(i)/FACTOR
        dv( 1) = 1.0D00
        dv( 2) = x
        dv( 3) = y
        dv( 4) = x*x
        dv( 5) = x*y
        dv( 6) = y*y
        dv( 7) = x*x*x
        dv( 8) = x*x*y
        dv( 9) = x*y*y
        dv(10) = y*y*y
        xhat = 0.0D00
        yhat = 0.0D00
        DO j=1,ncoef
          xhat = xhat + dv(j)*xcoef(j)
          yhat = yhat + dv(j)*ycoef(j)
        ENDDO
        xx(i) = xhat*FACTOR
        yy(i) = yhat*FACTOR
      ENDDO
      ximin = MIN(xx(1),xx(2),xx(3),xx(4))
      ximax = MAX(xx(1),xx(2),xx(3),xx(4))
      etamin = MIN(yy(1),yy(2),yy(3),yy(4))
      etamax = MAX(yy(1),yy(2),yy(3),yy(4))
      RETURN
c
c...No File Means No Improvement
c
  200 WRITE (*,9002) lb(1:nlb)
      ximin = TOOSMALL
      ximax = TOOBIG
      etamin = TOOSMALL
      etamax = TOOBIG
      RETURN
      END
