      PROGRAM  gensr
c
c...Generate Southern Red Declination Zone TAFF Input Catalogs
c
      IMPLICIT
     *         NONE
      INTEGER
     *         i, u
      CHARACTER*1
     *         c
      CHARACTER*9
     *         lb
c
 9001 FORMAT ('/uw6/xpmm/auxgsc', a, '/gr', i4.4, '.res')
 9002 FORMAT ('srzone.', i2.2)
c
c...Open All The Units
c
  100 DO u=31,39
        WRITE (lb,9002) u
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=lb,
     *        status='unknown',
     *        unit=u
     *       )
      ENDDO
c
c...Write The File Names
c
      DO i=1,894
        c = CHAR(ICHAR('a')+(i/100))
        IF (i.le.110) THEN
          u = 31
        ELSEIF (i.le.192) THEN
          u = 32
        ELSEIF (i.le.292) THEN
          u = 33
        ELSEIF (i.le.408) THEN
          u = 34
        ELSEIF (i.le.537) THEN
          u = 35
        ELSEIF (i.le.606) THEN
          u = 36
        ELSEIF (i.le.678) THEN
          u = 37
        ELSEIF (i.le.822) THEN
          u = 38
        ELSE
          u = 39
        ENDIF
        WRITE (u,9001) c,i
      ENDDO
c
c...Close Everybody
c
      DO u=31,39
        CLOSE (unit=u)
      ENDDO
      CALL EXIT
      END
