      SUBROUTINE  cdgenerate(prefix,first)
c
c...Scan List And Prepare Files
c
      INCLUDE
     *            'cdrom.inc'
c
c...Note:  640*1024 assumes 1024 vs 1000
c	   610*1024 assumes 1000
c
      PARAMETER
     *            cdsize = (640*1024)
      CHARACTER*(*)
     *            prefix
      CHARACTER*64
     *            fn
      INTEGER
     *            i, id, count, first, get, nlist, list(NMAX),
     *            nfn, ncd, ntotal
      REAL
     *            mb, x, y, z, xx
c
 9001 FORMAT (a, 'cd.', i3.3)
 9002 FORMAT (' File ', a, '  MB=', f5.1)
 9003 FORMAT (' Packing Efficiency=', f4.1, '  Space=', f4.1)
c
c...Initialization
c
  100 id = first-1
      get = 0
      nfn = LEN(prefix)+6
      ntotal = 0
      ncd = 0
c
c...Next Chunk
c
  110 id = id+1
      count = 0
      nlist = 0
c
c...Fill CD-ROM In Numerical Order
c
  120 get = get+1
      IF (get.gt.NMAX) GO TO 130
      IF (blocks(get).le.0) GO TO 120
      IF ((count+blocks(get)).le.CDSIZE) THEN
        count = count+blocks(get)
        nlist = nlist+1
        list(nlist) = get
        GO TO 120
      ENDIF
c
c...Attempt To Fill Even More
c
      DO i=get+1,NMAX
        IF ((count+blocks(i)).le.CDSIZE) THEN
          count = count+blocks(i)
          nlist = nlist+1
          list(nlist) = i
          blocks(i) = 0
        ENDIF
      ENDDO
c
c...This CD-ROM Is Full
c
      WRITE (fn,9001) prefix,id
      mb = count/1024.0
      WRITE (*,9002) fn(1:nfn),mb
      CALL cdextract(id,nlist,list)
      ncd = ncd+1
      ntotal = ntotal+count
      GO TO 110
c
c...Final CD-ROM
c
  130 IF (nlist.gt.0) THEN
        WRITE (fn,9001) prefix,id
        mb = count/1024.0
        WRITE (*,9002) fn(1:nfn),mb
        CALL cdextract(id,nlist,list)
c       ncd = ncd+1
c       ntotal = ntotal+count
      ENDIF
c
c...Final Efficiency Calculation
c
      x = ntotal
      y = ncd*CDSIZE
      z = 100.0*x/y
      xx = (y-x)/CDSIZE
      WRITE (*,9003) z,xx
      RETURN
      END
