      SUBROUTINE  mumucheck
c
c...Display Histogram of Quality And Distance
c
      INCLUDE
     *            'check.inc'
      PARAMETER
     *            qmin = 3,
     *            rscale = 3.0
      INTEGER
     *            i, i1, i2, i3, i4, x1, y1, x2, y2, x3, y3, x4, y4,
     *            xbar, ybar, q, r, nqlow, nqhigh, nrlow, nrhigh,
     *            qhist(10), rhist(10), nqhist, nrhist
      REAL
     *            dx, dy, s
c
 9001 FORMAT (' Q(', i6, ',', i6, ',', i6, ')  R(', i6, ',', i6,
     * ',', i6, ')  QMin=', i1, '  RScale=', f3.1)
 9002 FORMAT (' (', i1, ')  N(Q)=', i6, '   N(R)=', i6)
c
  100 DO i=1,10
        qhist(i) = 0
        rhist(i) = 0
      ENDDO
      nqlow = 0
      nrlow = 0
      nqhigh = 0
      nrhigh = 0
      nqhist = 0
      nrhist = 0
      s = OBS_SCALE/100000.0D00
      DO i=1,npmu
        i1 = pmu(1,i)
        i2 = pmu(7,i)
        i3 = pmu(2,i)
        i4 = pmu(8,i)
        q = pmu(11,i)/100
        IF (q.lt.0) THEN
          nqlow = nqlow+1
        ELSEIF (q.ge.10) THEN
          nqhigh = nqhigh+1
        ELSE
          qhist(q+1) = qhist(q+1)+1
          nqhist = nqhist+1
        ENDIF
        IF (q.ge.QMIN) THEN
          x1 = xraw(i1,1)
          y1 = yraw(i1,1)
          x2 = xtmp(i2,1)
          y2 = ytmp(i2,1)
          CALL onexform(xraw(i3,3),yraw(i3,3),x3,y3)
          CALL onexform(xtmp(i4,2),ytmp(i4,2),x4,y4)
          dx = s*((1+x1+x2)/2 - (1+x3+x4)/2)
          dy = s*((1+y1+y2)/2 - (1+y3+y4)/2)
          r = SQRT(dx*dx+dy*dy)/RSCALE
          IF (r.lt.0) THEN
            nrlow = nrlow+1
          ELSEIF (r.ge.10) THEN
            nrhigh = nrhigh+1
          ELSE
            rhist(r+1) = rhist(r+1)+1
            nrhist = nrhist+1
          ENDIF
        ENDIF
      ENDDO
      WRITE (*,9001) nqlow,nqhist,nqhigh,nrlow,nrhist,nrhigh,QMIN,
     *               RSCALE
      DO i=1,10
        i1 = i-1
        WRITE (*,9002) i1,qhist(i),rhist(i)
      ENDDO
      RETURN
      END
