      PROGRAM  probmgo
c
c...Contour Plot Of Probabilty Table
c
      INCLUDE
     *            'mujfoe.inc'
      PARAMETER
     *            nlmax = 5
      INTEGER
     *            n, i, ix, iy, nl, r, nlb, ntb,
     *            npx, npy, nrm
      REAL
     *            l0, dl, level(NLMAX), buf(PROBDIM*PROBDIM), zmn, zmx
      CHARACTER*64
     *            lb, tb
c
 9001 FORMAT ('Probability From Ridge ', i2)
 9002 FORMAT ('AUXJFOE:p', i4.4, 'q', i4.4, '.inf')
 9003 FORMAT (q, a)
 9004 FORMAT (' Cannot Open ', a)
 9005 FORMAT (4i10)
 9006 FORMAT (' Enter Ridge: ' $)
 9007 FORMAT (' Illegal Size ', 3i10)
 9008 FORMAT (' Illegal Ridge', 2i10)
 9009 FORMAT (20x, 2f10.0)
c
c...Read Tables
c
  100 CALL probopen
      WRITE (lb,9002) jfid,oeid
      nlb = 22
      CALL f_doenv(lb(1:nlb),ntb,tb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9005) npx,npy,nrm,nr
      DO i=1,nr
        READ (1,9005) probmin(i),probwid(i)
      ENDDO
      CLOSE (1)
      IF  ((npx.ne.PROBDIM).or.(npy.ne.PROBDIM)
     * .or.(nrm.ne.NRMAX)) THEN
        WRITE (*,9007) npx,npy,nrm
        CALL EXIT
      ENDIF
      tb(ntb-2:ntb) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      recl=(npx*npy*nrm),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) prob
      CLOSE (1)
c
c...Loop To Plot Ridges
c
  110 WRITE (*,9006)
      READ  (*,9003,err=110,end=210) nlb,lb
      IF (nlb.le.0) GO TO 210
      READ (lb(1:nlb),9005,err=110) r
      IF ((r.le.0).or.(r.gt.nr)) THEN
        WRITE (*,9008) r,nr
        GO TO 110
      ENDIF
c
c...Do The Plot
c
      l0 = 0
      dl = 1.0
      nl = NLMAX
      DO i=1,nl
        level(i) = l0 + (i-1)*dl
      ENDDO
      CALL mgoinit
      CALL mgosetup(-7)
      zmn = 1.0
      zmx = PROBDIM
      CALL mgosetlim(zmn,zmn, zmx,zmx)
      CALL mgobox(1,1)
      CALL mgoxlabel(43,'SJ Magnitude (tenths, arbitrary zero point)')
      CALL mgoylabel(43,'SO Magnitude (tenths, arbitrary zero point)')
      i = 0
      DO iy=1,PROBDIM
        DO ix=1,PROBDIM
          i = i+1
          buf(i) = prob(ix,iy,r)
        ENDDO
      ENDDO
      CALL mgocontour(buf, PROBDIM,PROBDIM, level,nl)
      CALL mgoprntplot(i)
      GO TO 110
c
c...Exits
c
  200 WRITE (*,9004) tb(1:ntb)
      GO TO 100
  210 CALL EXIT
      END
