      PROGRAM  genhist
c
c...Generate Histogram Of Residuals
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1*1000*1000,
     *         nhmax = 200
      INTEGER
     *         nroot, nbigbuf, npair, i, n, buf(50), j, low, high,
     *         xhist(NHMAX), yhist(NHMAX), xlow, xhigh, ylow, yhigh,
     *         idx(NMAX), z1, z2, z3
      REAL
     *         xres(NMAX), yres(NMAX), frst, wide, x, tmp(NMAX),
     *         x1, x2, x3, y1, y2, y3, sx, sxx, sy, syy
      CHARACTER*64
     *         root
c
 9001 FORMAT (2i10)
 9002 FORMAT (' Enter Root: ' $)
 9003 FORMAT (q, a)
 9004 FORMAT (' Cannot Open ', a)
 9005 FORMAT (' Enter FRST,WIDE,NBIN: ' $)
 9006 FORMAT (2f10.0, i10)
 9007 FORMAT (f10.3, 2i10)
 9008 FORMAT (' XL=', i6, '  XH=', i6, '  YL=', i6, '  YH=', i6)
 9009 FORMAT (' X Sigmas  1=', f4.1, '  2=', f4.1, '  3=', f4.1)
 9010 FORMAT (' Y Sigmax  1=', f4.1, '  2=', f4.1, '  3=', f4.1)
 9011 FORMAT (' X=', f4.1, '+/-', f4.1, '  Y=', f4.1, '+/-', f4.1)
c
c...Get Root And Open BINF File
c
  100 WRITE (*,9002)
      READ  (*,9003,err=100,end=210) nroot,root
      IF (nroot.le.0) GO TO 100
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=root(1:nroot)//'.binf',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) nbigbuf,npair
      CLOSE (1)
      n = 2*nbigbuf+2
c
c...Load The BYES Residuals
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=root(1:nroot)//'.byes',
     *      readonly,
     *      recordtype='fixed',
     *      recl=n,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,npair
        READ (1,rec=i) (buf(j),j=1,n)
        high = buf(n)/20000
        low = buf(n) - high*20000
        xres(i) = 0.01*( low-10000)
        yres(i) = 0.01*(high-10000)
      ENDDO
      CLOSE (1)
c
c...Compute The Histogram
c
  120 WRITE (*,9005)
      READ  (*,9006,err=120,end=210) frst,wide,n
      IF ((wide.le.0.0).or.(n.le.0)) GO TO 120
      DO j=1,n
        xhist(j) = 0
        yhist(j) = 0
      ENDDO
      xlow = 0
      ylow = 0
      xhigh = 0
      yhigh = 0
      DO i=1,npair
        j = (xres(i)-frst)/wide + 1.0
        IF (j.le.0) THEN
          xlow = xlow+1
        ELSEIF (j.gt.n) THEN
          xhigh = xhigh+1
        ELSE
          xhist(j) = xhist(j)+1
        ENDIF
        j = (yres(i)-frst)/wide + 1.0
        IF (j.le.0) THEN
          ylow = ylow+1
        ELSEIF (j.gt.n) THEN
          yhigh = yhigh+1
        ELSE
          yhist(j) = yhist(j)+1
        ENDIF
      ENDDO
c
c...Save The Results
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=root(1:nroot)//'.hist',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,n
        x = frst + (i-0.5)*wide
        WRITE (1,9007) x,xhist(i),yhist(i)
      ENDDO
      CLOSE (1)
      WRITE (*,9008) xlow,xhigh,ylow,yhigh
c
c...Compute Sigmas
c
      z1 = 1.0 + 0.68269*npair
      z2 = 1.0 + 0.95449*npair
      z3 = 1.0 + 0.99370*npair
      DO i=1,npair
        tmp(i) = ABS(xres(i))
        idx(i) = i
      ENDDO
      CALL ruqsrt(npair,tmp,idx)
      x1 = tmp(z1)
      x2 = tmp(z2)
      x3 = tmp(z3)
      DO i=1,npair
        tmp(i) = ABS(yres(i))
        idx(i) = i
      ENDDO
      CALL ruqsrt(npair,tmp,idx)
      y1 = tmp(z1)
      y2 = tmp(z2)
      y3 = tmp(z3)
      WRITE (*,9009) x1,x2,x3
      WRITE (*,9010) y1,y2,y3
c
c...Do Normal Sigmas
c
      sx = 0.0
      sxx = 0.0
      sy = 0.0
      syy = 0.0
      DO i=1,npair
        sx = sx + xres(i)
        sxx = sxx + xres(i)*xres(i)
        sy = sy + yres(i)
        syy = syy + yres(i)*yres(i)
      ENDDO
      sx = sx/npair
      sxx = SQRT(sxx/npair - sx*sx)
      sy = sy/npair
      syy = SQRT(syy/npair - sy*sy)
      WRITE (*,9011) sx,sxx,sy,syy
c
c...All Done
c
      CALL EXIT
  200 WRITE (*,9004) root(1:nroot)
      GO TO 100
  210 CALL EXIT
      END
