      PROGRAM  datconvert
c
c...Convert BINARY PMM Files Into ASCII.  Save only X,Y,M
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1*1000*1000
      INTEGER
     *         x(NMAX), y(NMAX), m(NMAX), i, n, nlb, nfi, nfo
      CHARACTER*64
     *         lb, fi, fo
c
 9001 FORMAT (' Enter ROOT: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (i10)
 9004 FORMAT (3i12)
 9005 FORMAT (' Converted N=', i12, ' Entries From ', a)
c
c...Assemble File Names
c
  100 WRITE (*,9001)
      READ  (*,9002,err=100,end=200) nlb,lb
      IF (nlb.le.0) GO TO 200
      fi = '/uf0/xpmm/8inch/'//lb(1:nlb)//'.inf'
      nfi = 20 + nlb
      fo = lb(1:nlb)//'.asc'
      nfo = nlb+4
c
c...Get Length From INF File
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=100,
     *      form='formatted',
     *      name=fi(1:nfi),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003) n
      CLOSE (1)
c
c...Read The DAT File And Strip Magnitude Word
c
      fi(nfi-2:nfi) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=fi(1:nfi),
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec= 4) (m(i),i=1,n)
      READ (1,rec= 9) (x(i),i=1,n)
      READ (1,rec=10) (y(i),i=1,n)
      CLOSE (1)
      DO i=1,n
        m(i) = MOD(m(i),10000)
      ENDDO
c
c...Open, Write, And Close ASCII File
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=fo(1:nfo),
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9004) n
      DO i=1,n
        WRITE (1,9004) x(i),y(i),m(i)
      ENDDO
      CLOSE (1)
      WRITE (*,9005) n,lb(1:nlb)
      GO TO 100
c
c...Exit
c
  200 CALL EXIT
      END
