      subroutine  byepoch
c
c...evaluates residuals by epoch
c
      include   'pa6inc1.inc'
      dimension sx1(ls,lp), sx2(ls,lp), sxw(ls,lp),
     *          sy1(ls,lp), sy2(ls,lp), syw(ls,lp),
     *          ipfrst(lp), iplast(lp), iwork(lp), jwork(lp),
     *          xpass(ls), wxpass(ls), ypass(ls), wypass(ls),
     *          apass(ls), wapass(ls), bpass(ls), wbpass(ls),
     *          cpass(lp), pixm(lp), pixs(lp), piym(lp), piys(lp)
c
 9201 FORMAT (28H1RESIDUALS BY EPOCH...EPEPS=, F6.3, 10H   ZDLIMT=,
     * f7.3)
 9202 FORMAT ( 3H0T=, F6.3, 7H   ZDX=, F6.3, 7H   ZDY=, F6.3)
 9203 FORMAT (18H1RESIDUALS BY STAR)
 9204 FORMAT ( 6H0STAR=, I5)
 9205 FORMAT (14H1PARALLAX STAR)
 9206 FORMAT ( 5H <X>=, F7.3, 3H+/-, F6.3, 7H   <Y>=, F7.3, 3H+/-,
     * f6.3, 10h   plates=, (19i4))
c
c...determine plates in each distince epoch/zd interval
c
      j=0
      nput=0
  100 iplate=j+1
      j=iplate
      if (iplate.gt.nplate) go to 120
      tref=tplate(iplate)
      zxref=pzdx(iplate)
      zyref=pzdy(iplate)
      nput=nput+1
      ipfrst(nput)=iplate
      iplast(nput)=iplate
      do 110 i=iplate+1,nplate
      if  ((abs(tplate(i) -  tref).gt. epeps)
     * .or.(abs(  pzdx(i) - zxref).gt.zdlimt)
     * .or.(abs(  pzdy(i) - zyref).gt.zdlimt)) go to 100
      iplast(nput)=i
      j=i
  110 continue
  120 if (nput.le.0) return
      do 130 ip=1,nput
      do 130 is=1,nstar
      sx1(is,ip)=0.0
      sx2(is,ip)=0.0
      sxw(is,ip)=0.0
      sy1(is,ip)=0.0
      sy2(is,ip)=0.0
  130 syw(is,ip)=0.0
c
c...compute the mean star residuals for each distinct epoch
c
  200 do 230 ip=1,nput
      do 220 iplate=ipfrst(ip),iplast(ip)
        w=wplate(iplate)
        if (w.le.0.0) go to 220
      do 210 is=1,nstar
        x=xresid(is,iplate)
        y=yresid(is,iplate)
      if (x.ne.tag) then
          sx1(is,ip)=sx1(is,ip) + w*x
          sx2(is,ip)=sx2(is,ip) + w*x*x
          sxw(is,ip)=sxw(is,ip) + w
      endif
      if (y.ne.tag) then
          sy1(is,ip)=sy1(is,ip) + w*y
          sy2(is,ip)=sy2(is,ip) + w*y*y
          syw(is,ip)=syw(is,ip) + w
      endif
  210 continue
  220 continue
  230 continue
      do 250 ip=1,nput
      do 240 is=1,nstar
      if (sxw(is,ip).gt.0.0) then
          sx1(is,ip)=sx1(is,ip)/sxw(is,ip)
          sx2(is,ip)=sqrt(abs(sx2(is,ip)/sxw(is,ip) - sx1(is,ip)**2))
      endif
      if (syw(is,ip).gt.0.0) then
          sy1(is,ip)=sy1(is,ip)/syw(is,ip)
          sy2(is,ip)=sqrt(abs(sy2(is,ip)/syw(is,ip) - sy1(is,ip)**2))
      endif
  240 continue
  250 continue
c
c...process each epoch by itself
c
  300 write (2,9201,iostat=junk) epeps,zdlimt
      do 320 ip=1,nput
      napass=0
      nbpass=0
      do 310 is=1,nstar
      if (instar(is).eq.0) go to 310
      if (sxw(is,ip).gt.0.0) then
        napass=napass+1
        apass(napass)=sx1(is,ip)
        wapass(napass)=sxw(is,ip)
      endif
      if (syw(is,ip).gt.0.0) then
        nbpass=nbpass+1
        bpass(nbpass)=sy1(is,ip)
        wbpass(nbpass)=syw(is,ip)
      endif
  310 continue
      i=ipfrst(ip)
      write (2,9202,iostat=junk) tplate(i),pzdx(i),pzdy(i)
      call dohist(1,napass,apass,wapass)
      call dohist(2,nbpass,bpass,wbpass)
  320 continue
c
c...process each star by itself
c
  400 write (2,9203,iostat=junk)
      do 420 is=1,nstar
      if (instar(is).eq.0) go to 420
      nxpass=0
      nypass=0
      do 410 ip=1,nput
      if (sxw(is,ip).gt.0.0) then
        nxpass=nxpass+1
        xpass(nxpass)=sx1(is,ip)
        wxpass(nxpass)=sxw(is,ip)
      endif
      if (syw(is,ip).gt.0.0) then
        nypass=nypass+1
        ypass(nypass)=sy1(is,ip)
        wypass(nypass)=syw(is,ip)
      endif
  410 continue
      write (2,9204,iostat=junk) looks(is)
      call dohist(1,nxpass,xpass,wxpass)
      call dohist(2,nxpass,ypass,wypass)
  420 continue
c
c...special processing for the parallax star
c
  500 if ((iparst.ge.1).and.(iparst.le.nstar)) then
        write (2,9205,iostat=junk)
        do 520 ip=1,nput
        i=ipfrst(ip)
        cpass(ip)=tplate(i)
        apass(ip)=pzdx(i)
        bpass(ip)=parfx(i)
        wapass(ip)=pzdy(i)
        wbpass(ip)=parfy(i)
        pixm(ip)=sx1(iparst,ip)
        pixs(ip)=sx2(iparst,ip)
        piym(ip)=sy1(iparst,ip)
        piys(ip)=sy2(iparst,ip)
        j=0
        do 510 i=ipfrst(ip),iplast(ip)
        j=j+1
  510   iwork(j)=lookp(i)
        write (2,9206,iostat=junk) sx1(iparst,ip),sx2(iparst,ip),
     *   sy1(iparst,ip),sy2(iparst,ip),(iwork(i),i=1,j)
        jwork(ip)=iwork(1)
        pixs(ip)=sigpcx/sqrt(real(max(1,j)))
        piys(ip)=sigpcy/sqrt(real(max(1,j)))
  520   continue
      endif
c
      return
      end
