      FUNCTION  correct(ixy,istar,iplate)
c
c...Apply Various Corrections AFTER Plate Constants BEFORE Parallax
c
c	ICORRECT	Should Corrections Be Applied?
c			   0=NO
c			   1=YES
c	IOBSY		Observatory for interpretation of input values
c			for ZDSLOPE and COLOFF
c			   1=KPNO
c			   2=USNO
c			This is only of use in the interpretation of the
c			sign of the correction.
c	IXY		Direction of the current fit.
c			   1=X Solution
c			   2=Y Solution
c			   Under normal circumstances, the X solution
c			   is closely aligned East/West and the Y is
c			   North/South.  The sign of the direction is
c			   most often (+x = East, -y=North) for KPNO
c			   initial guess frames and (-x=East, -Y=North)
c			   for USNO initial guesses.
c	NOBS		Identifies Which Obseravatory
c			   1=KPNO (19.65 arcseconds/millimeter)
c			   2=USNO (13.55 arcseconds/millimeter)
c			   NOTE:  USNO Data are often computed on the
c			          basis of 15.00 micron pixels.  The
c				  true value is 15.24.  This yields an
c				  apparent scale of 13.77 arcseconds
c				  per millimeter at USNO-FS.
c	NFIL		Identifies Which Type of Filter
c			   1=VCam V
c			   2=VCam R
c			   3=VCam I
c			   4=ST Wide V
c			   5=ST Wide R
c			   6=ST Wide I
c	ZDSLOPE		Slope of Applied Zenith Distance Correction
c			 in units as computed by least squares fit
c			 (usually microns/tan(zd)).  Should be similar
c			 in sign and magnitude to that computed by fit.
c	COLOFF		Shift (observatory-specific units) to be applied
c			 to data.
c
c   Extremely Temporary Code.  Use and Edit With Caution!!!!!
c
      INCLUDE
     *            'pa6inc1.inc'
      DATA
     *            iload/0/
c
 9201 FORMAT ('1*****  Corrections Enabled *****')
 9202 FORMAT ('0ZDSLOPE=', f10.5)
 9203 FORMAT (' COLOFF =', f10.5)
 9601 FORMAT (' *****  Corrections Enabled *****')
c
c...Quick Return If Nothing To Do
c
      correct = 0.0
      IF (icorrect.eq.0)            RETURN
      IF (zdslope.eq.0.0)           RETURN
      IF (istar.ne.iparst)          RETURN
      IF ((ixy.lt.1).or.(ixy.gt.2)) RETURN
c
c...Assume that there is NO correction needed.
c
      correct=0.0
c
c...OneTime Initialization
c
      IF (iload.eq.0) THEN
        iload=1
        IF (iobsy.eq.1) THEN
          xsl=zdslope
          ysl=-zdslope
        ELSE
          xsl=zdslope
          ysl=zdslope
        ENDIF
      WRITE (2,9201)
      WRITE (*,9601)
      WRITE (2,9202) zdslope
      WRITE (2,9203) coloff
      ENDIF
c
c...Rather Complex Logic To Figure Out Telescope and Filter
c
c	This should eventually be included in header card for each frame.
c
      IF (lookp(iplate).lt.500) THEN
         itel=1
         ifil=2
      ELSE
         itel=2
         ifil=5
      ENDIF
c
      IF (abs(tplate(iplate)-83.535).le.0.006) THEN
         itel=1
      ENDIF
c
      IF (abs(tplate(iplate)-83.016).le.0.006) THEN
         iflip=1
      ELSE
         iflip=0
      ENDIF
c
      IF (abs(tplate(iplate)-83.287).le.0.006) THEN
         ifil=6
      ENDIF
c
c...Compute the Refractive Displacement
c
      IF (ixy.eq.1) THEN
        z=pzdx(iplate)
        s=xsl
        o=coloff
        c=xcalc(istar,iplate)
      ELSE
        z=pzdy(iplate)
        s=ysl
        o=coloff
        c=ycalc(istar,iplate)
      ENDIF
      IF ((z.eq.tag).or.(c.eq.tag)) THEN
        corr1=0.0
      ELSE
        corr1=(-z*s)
      ENDIF
c
c...Now Apply Correction Systematic Displacement in X for KPNO
c	doublet corrector problems
c
      IF (itel.eq.1) THEN
        IF (iflip.eq.1) THEN
          corr2=-coloff
        ELSE
          corr2= coloff
        ENDIF
      ELSE
        corr2=0.0
      ENDIF
c
c...Assemble the pieces and return
c
      correct=corr1 + corr2
      RETURN
      END
