      SUBROUTINE  dophzd
c
c...Use Photometry To Correct Raw Measures For ZD Effects
c
c	ASSUMES:	Coefficients Same In X and Y
c	ASSUMES:	Polynomial Coefficients Not Computed In A6
c	ASSUMES:	Coefficents Are Relevant To Colors On COLOR Cards
c
c	NOPHZD		See READER For Locations Of Flag Field
c			(Select/Deselect This Processing)
c	IOBSY		Coded Telescope/Filter Combination
c	==1		KPNO + VCAM-R
c	==2		NOFS + Wide ST-R
c	==3		(alternate NOFW+Wide ST-R)
c
      INCLUDE
     *            'pa6inc1.inc'
      DIMENSION
     *            coef(10)
c
 9001 FORMAT (' >>> Photometric ZD Processing DISABLED <<<')
 9002 FORMAT (' Unknown IOBSY Code = ', i10)
 9003 FORMAT (' >>> Photometric ZD Correction Applied To Star ', i5,
     *        ':  V=', f5.2, '   (V-I)=', f5.2, ' <<<')
c
c...Quick Return If Not Desired
c
  100 IF (nophzd.ne.0) THEN
        WRITE (*,9001)
        WRITE (2,9001)
        RETURN
      ENDIF
c
c...Load Coefficients
c
      CALL phzddata(ncoef,coef,iok)
      IF (iok.eq.0) THEN
        WRITE (*,9002) iobsy
        WRITE (*,9001)
        WRITE (2,9001)
        RETURN
      ENDIF
c
c...Apply The Correction
c
      DO istar=1,nstar
        a = abar(istar)
        c = acol(istar)
        IF ((a.ne.tag).and.(a.ne.0.0).and.(c.ne.tag)) THEN
          WRITE (*,9003) looks(istar),a,c
          WRITE (2,9003) looks(istar),a,c
          DO iplate=1,nplate
            zx = pzdx(iplate)
            zy = pzdy(iplate)
            x = xcoord(istar,iplate)
            y = ycoord(istar,iplate)
            IF ((x.ne.tag).and.(y.ne.tag)) THEN
              CALL phzdcorr(c,zx,zy,ncoef,coef,z,y,dx,dy)
              xcoord(istar,iplate) = xcoord(istar,iplate) - dx
              ycoord(istar,iplate) = ycoord(istar,iplate) - dy
            ENDIF
          ENDDO
        ENDIF
      ENDDO
      END
