      subroutine newscan
c
c...see whether there are enough stars (now) to include plate
c
      include 'pa6inc1.inc'
c
c...consider the x-axis solution
c
  100 do 120 iplate=1,nplate
c
c...is this plate already in the solution ?
c
      if (pconx(1,iplate).ne.tag) go to 120
      do 110 istar=1,nstar
c
c...is this star alreay included ?
c
      if (xcalc(istar,iplate).ne.tag) go to 110
c
c...is this star interesting ?
c
      if (instar(istar).eq.0) go to 110
c
c...do we know where it is anywhere ?
c
      if (xbar(istar).eq.tag) go to 110
c
c...is this star measured on this plate ?
c
      if  ((xcoord(istar,iplate).eq.tag)
     * .or.(ycoord(istar,iplate).eq.tag)
     * .or.(abar(istar)         .eq.tag)
     * .or.(acol(istar)         .eq.tag)) go to 110
c
c...create a new "calculated" position
c
      x=xbar(istar)
      if ( xmu(istar).ne.tag) x=x + xmu(istar)*(tplate(iplate) - tbar)
      if (xpar(istar).ne.tag) x=x + xpar(istar)*parfx(iplate)
      if (szdx(istar).ne.tag) x=x + szdx(istar)*pzdx(iplate)
      xcalc(istar,iplate)=x
      xresid(istar,iplate)=0.0
  110 continue
  120 continue
c
c...consider the y-axis solution
c
      do 140 iplate=1,nplate
c
c...is this plate already in the solution ?
c
      if (pcony(1,iplate).ne.tag) go to 140
      do 130 istar=1,nstar
c
c...is this star alreay included ?
c
      if (ycalc(istar,iplate).ne.tag) go to 130
c
c...is this star interesting ?
c
      if (instar(istar).eq.0) go to 130
c
c...do we know where it is anywhere ?
c
      if (ybar(istar).eq.tag) go to 130
c
c...is this star measured on this plate ?
c
      if  ((xcoord(istar,iplate).eq.tag)
     * .or.(ycoord(istar,iplate).eq.tag)
     * .or.(abar(istar)         .eq.tag)
     * .or.(acol(istar)         .eq.tag)) go to 130
c
c...create a new "calculated" position
c
      y=ybar(istar)
      if ( ymu(istar).ne.tag) y=y + ymu(istar)*(tplate(iplate) - tbar)
      if (ypar(istar).ne.tag) y=y + ypar(istar)*parfy(iplate)
      if (szdy(istar).ne.tag) y=y + szdy(istar)*pzdy(iplate)
      ycalc(istar,iplate)=y
      yresid(istar,iplate)=0.0
  130 continue
  140 continue
c
      return
      end
