      subroutine zdfit(in,qpzd)
c
c...this fit includes only the zenith distance terms
c
      include 'pa6inc1.inc'
      parameter (l1=lc+1,l2=lc+2,l3=lc+3,l4=lc+4)
      dimension qpzd(*),xx(3),yy(3),ww(3)
      dimension zrhs(lc,lc),zlhs(lc),dv(lc),coef(lc),scoef(lc),
     * qcoord(lp),qresid(lp),qfit(lp),sqfit(lp),kok(lp)
      equivalence (qcoord(1),work1(1,1)),(qresid(1),work1(1,2)),
     * (qfit(1),work1(1,3)),(sqfit(1),work1(1,4)),(kok(1),work1(1,5))
      data nfmax/4/
c
 9601 FORMAT (' SINGULAR MATRIX IN ZDFIT...NFIT=', I3)
 9602 FORMAT (1X, I3, 2(2X, F10.4))
c
c...initialize
c
      do 90 ifit=1,nfmax
       qfit(ifit)=tag
   90 sqfit(ifit)=tag
c
c...count the number of valid data points and get mean
c    the array kok(i)=1 for valid data points.
c
      nin=0
      w=0.0
      z=0.0
      do 120 iplate=1,nplate
      kok(iplate)=0
      if (   qcoord(iplate).eq.tag)  go to 120
      w=w + wplate(iplate)
      z=z + wplate(iplate)*qcoord(iplate)
      if (    (qpzd(iplate).eq.tag)
     *    .or.(qpzd(iplate).eq.0.0)) go to 120
      kok(iplate)=1
      if (nin.gt.0) go to 110
      nin=1
      zdmin=qpzd(iplate)
      zdmax=qpzd(iplate)
      go to 120
  110 nin=nin+1
      if (qpzd(iplate).lt.zdmin) zdmin=qpzd(iplate)
      if (qpzd(iplate).gt.zdmax) zdmax=qpzd(iplate)
  120 continue
      qcbar=tag
      if (w.gt.0.0) qcbar=z/w
c
c...here is the logic to select the solution parameters
c
      if (numzd.le.1) go to 200
      if (  nin.le.2) go to 200
      if ((zdmax-zdmin).lt.zdlimt) go to 200
      if (  nin.eq.3) go to 300
      nfit=nin-2
      if (nfit.gt.numzd) nfit=numzd
      if (nfit.gt.nfmax) nfit=nfmax
      free=nin - (nfit+1)
      go to 400
c
c...here is process for <3 acceptable points
c    only mean can be computed
c
  200 if (qcbar.eq.tag) go to 220
      qfit(1)=qcbar
      nin=0
      chisq=0.0
      do 210 iplate=1,nplate
      if (qcoord(iplate).eq.tag) go to 210
      nin=nin+1
      zc=qcoord(iplate) - qcbar
      qresid(iplate)=zc
      chisq=chisq + wplate(iplate)*zc*zc
  210 continue
      free=nin-1
      if (free.gt.0.0) sqfit(1)=sqrt(chisq/free)
  220 return
c
c...special case logic to fit 3 observations to 2 variables
c
  300 iq=0
      do 310 iplate=1,nplate
      if (kok(iplate).eq.0) go to 310
      iq=iq+1
      xx(iq)=  qpzd(iplate)
      yy(iq)=qcoord(iplate) - qcbar
      ww(iq)=wplate(iplate)
  310 continue
      s1=(yy(2)-yy(1))/(xx(2)-xx(1))
      s2=(yy(3)-yy(2))/(xx(3)-xx(2))
      w1=ww(1)+ww(2)
      w2=ww(2)+ww(3)
      sbar=(w1*s1 + w2*s2)/(w1+w2)
      ssig=sqrt((w1*(s1-sbar)**2 + w2*(s2-sbar)**2)/(w1+w2))
      r1=yy(1) - sbar*xx(1)
      r2=yy(2) - sbar*xx(2)
      r3=yy(3) - sbar*xx(3)
      rbar=(ww(1)*r1 + ww(2)*r2 + ww(3)*r3)/(ww(1)+ww(2)+ww(3))
      rsig=ww(1)*(r1-rbar)**2 + ww(2)*(r2-rbar)**2 + ww(3)*(r3-rbar)**2
      rsig=sqrt(rsig/(ww(1)+ww(2)+ww(3)))
      qfit(1)=rbar + qcbar
      sqfit(1)=rsig
      qfit(2)=sbar
      sqfit(2)=ssig
      do 320 iplate=1,nplate
      qresid(iplate)=tag
      if (kok(iplate).eq.0) go to 320
      qresid(iplate)=qcoord(iplate) - (qfit(1) + qfit(2)*qpzd(iplate))
  320 continue
      return
c
c...here to do the requested fit
c
  400 do 410 ifit=1,nfit
      zlhs(ifit)=0.0
      do 410 jfit=1,nfit
  410 zrhs(ifit,jfit)=0.0
      do 430 iplate=1,nplate
      if (kok(iplate).eq.0) go to 430
      dv(1)=1.0
      do 415 ifit=2,nfit
  415 dv(ifit)=qpzd(iplate)**(ifit-1)
      w=wplate(iplate)
      z=qcoord(iplate) - qcbar
      do 420 ifit=1,nfit
      zlhs(ifit)=zlhs(ifit) + w*z*dv(ifit)
      do 420 jfit=1,nfit
  420 zrhs(ifit,jfit)=zrhs(ifit,jfit) + w*dv(ifit)*dv(jfit)
  430 continue
      call matinv(zrhs,nfit,lc,det)
      if (det.ne.0.0) go to 435
      write (*,9601,iostat=junk) nfit
      do 432 i=1,nplate
  432 write (*,9602,iostat=junk) i,qcoord(i),qpzd(i)
      call doclose(0)
      stop 'fortran stop...singular matrix in zdfit'
  435 do 440 ifit=1,nfit
      coef(ifit)=0.0
      do 440 jfit=1,nfit
  440 coef(ifit)=coef(ifit) + zrhs(ifit,jfit)*zlhs(jfit)
      chisq=0.0
      do 470 iplate=1,nplate
      qresid(iplate)=tag
      if (kok(iplate).eq.0) go to 470
  450 dv(1)=1.0
      do 455 ifit=2,nfit
  455 dv(ifit)=qpzd(iplate)**(ifit-1)
      w=wplate(iplate)
      z=qcoord(iplate) - qcbar
      zc=0.0
      do 460 ifit=1,nfit
  460 zc=zc + coef(ifit)*dv(ifit)
      qresid(iplate)=z-zc
      chisq=chisq + w*(z-zc)*(z-zc)
  470 continue
      stder=sqrt(chisq/free)
      do 480 ifit=1,nfit
  480 scoef(ifit)=stder*sqrt(zrhs(ifit,ifit))
      do 490 ifit=1,nfit
      w=fdamp
      if (ifit.eq.1) w=1.0
  490 call damper(coef(ifit),scoef(ifit),qfit(ifit),sqfit(ifit),w,tag)
      qfit(1)=qfit(1) + qcbar
      return
      end
