      subroutine zdscan
c
c...this imposes plausibility limits on the zenith distance coefficients
c
      include 'pa6inc1.inc'
c
 9201 FORMAT ('0  RAW ZD COEFFICIENTS' /
     * ' star in', 5x, 'x-linear s/n', 5x, 'y-linear s/n')
 9202 FORMAT (1X, I5, 3X, I1, 2(5X, F7.3, 1X, F4.1))
 9203 FORMAT ('0FILTERING COEFFICIENTS:   TOOBIG=', F4.1,
     * '   thresh1=', f4.1, '   thresh2=', f4.1)
 9204 FORMAT ('0FILTERED ZD COEFFICIENTS' /
     * ' star in', 5x, 'x-linear s/n', 5x, 'y-linear s/n')
c
c...this routine is a no-op if modezd.eq.1
c
      if (modezd.eq.1) return
c
c...significnace is checked
      write (2,9201,iostat=junk)
      do 130 istar=1,nstar
      snrx=0.0
      if ((sszdx(istar).eq.tag).or.(sszdx(istar).le.0.0)) go to 110
      snrx=abs(szdx(istar)/sszdx(istar))
  110 snry=0.0
      if ((sszdy(istar).eq.tag).or.(sszdy(istar).le.0.0)) go to 120
      snry=abs(szdy(istar)/sszdy(istar))
  120 if ((snrx.le.0.0).and.(snry.le.0.0)) go to 130
      write (2,9202,iostat=junk) looks(istar),instar(istar),
     * szdx(istar),snrx,szdy(istar),snry
  130 continue
      write (2,9203,iostat=junk) toobig,thrsh1,thrsh2
      do 160 istar=1,nstar
      tx=szdx(istar)
      stx=sszdx(istar)
      ty=szdy(istar)
      sty=sszdy(istar)
      if (tx.eq.tag) go to 150
      if ((stx.eq.tag).or.(stx.le.0.0)) go to 150
      if (ty.eq.tag) go to 150
      if ((sty.eq.tag).or.(sty.le.0.0)) go to 150
      snrx=abs(tx/stx)
      snry=abs(ty/sty)
      r1=snrx
      r2=snry
      if (r1.ge.r2) go to 140
      r1=snry
      r2=snrx
  140 if ((r1.ge.toobig).or.(r1.lt.thrsh1)) go to 150
      if ((r2.ge.toobig).or.(r2.lt.thrsh2)) go to 150
      go to 160
  150 szdx(istar)=0.0
      sszdx(istar)=0.0
      szdy(istar)=0.0
      sszdy(istar)=0.0
  160 continue
      write (2,9204,iostat=junk)
      do 190 istar=1,nstar
      snrx=0.0
      if ((sszdx(istar).eq.tag).or.(sszdx(istar).le.0.0)) go to 170
      snrx=abs(szdx(istar)/sszdx(istar))
  170 snry=0.0
      if ((sszdy(istar).eq.tag).or.(sszdy(istar).le.0.0)) go to 180
      snry=abs(szdy(istar)/sszdy(istar))
  180 if ((snrx.le.0.0).and.(snry.le.0.0)) go to 190
      write (2,9202,iostat=junk) looks(istar),instar(istar),
     * szdx(istar),snrx,szdy(istar),snry
  190 continue
c
      return
      end
