      SUBROUTINE  gscproc(mode)
c
c...Scan GSC For Our Stars
c
      INCLUDE
     *            'possgsc.inc'
      INTEGER
     *            nbyte, nrec, nchunk, chunk, nbper, nblast, nsper,
     *            nslast, ns, err, GSC_OPEN, GSC_READ, GSC_CLOSE, nb,
     *            star, r, d, i, j, n, f, k, nprev(NFMAX), mode
c
 9001 FORMAT (' Fatal Error Opening GSC.DAT')
 9002 FORMAT (' Fatal Read Of GSC.DAT', 2i10)
 9003 FORMAT (' Illegal R/D', 6i11)
 9004 FORMAT (' GSC Chunk=', i2)
c
c...Open GSC And Get Number Of Records
c
  100 nbyte = GSC_OPEN()
      IF (nbyte.le.0) THEN
        WRITE (*,9001)
        CALL EXIT
      ENDIF
      nrec = nbyte/16
      nsper = NGSCBUF
      nchunk = (nrec-1)/nsper + 1
      nbper = nsper*16
      nslast = nrec - (nchunk-1)*nsper
      nblast = nslast*16
c
c...Outer Loop Over Chunks
c
      DO i=1,nfield
        nprev(i) = 0
      ENDDO
      DO chunk=1,nchunk
        WRITE (*,9004) chunk
        IF (chunk.lt.nchunk) THEN
          nb = nbper
          ns = nsper
        ELSE
          nb = nblast
          ns = nslast
        ENDIF
        err = GSC_READ(gscbuf,nb)
        IF (err.ne.0) THEN
          WRITE (*,9002) chunk,err
          CALL EXIT
        ENDIF
c
c...Inner Loop Over Entries
c
        DO star=1,ns
          r = gscbuf(2,star)/360000
          d = (gscbuf(3,star)-32400000)/360000
          IF ((r.lt.0).or.(r.gt.359).or.(d.lt.-89).or.(d.gt.89)) THEN
            WRITE (*,9003) r,d,(gscbuf(j,star),j=1,4)
      pause
          ELSE
            n = nlut(r,d)
            DO i=1,n
              f = lut(r,d,i)
              DO j=1,nfield
                IF (f.eq.field(j)) THEN
c
c...This Star Is In Our Field
c
                  k = nsave(j)
                  IF (k.lt.NSMAX) THEN
                    k = k+1
                    nsave(j) = k
                    isave(k,j) = gscbuf(1,star)
                    rsave(k,j) = gscbuf(2,star)
                    dsave(k,j) = gscbuf(3,star)
                    msave(k,j) = gscbuf(4,star)
                  ENDIF
                ENDIF
              ENDDO
            ENDDO
          ENDIF
c
c...End Of Loops
c
        ENDDO
        IF (mode.eq.0) THEN
          GO TO 120
        ELSE
          DO k=1,nfield
            IF (nsave(k).le.0) GO TO 110
          ENDDO
          DO k=1,nfield
            IF (nsave(k).ne.nprev(k)) GO TO 110
          ENDDO
          GO TO 130
  110     DO k=1,nfield
            nprev(k) = nsave(k)
          ENDDO
        ENDIF
  120   CONTINUE
      ENDDO
  130 CONTINUE
      RETURN
      END
