      PROGRAM  scheck
c
c...Compare HA To Verify Exposure Data
c
      INCLUDE
     *            'slalib.inc'
      PARAMETER
     *            np2 = 894
      CHARACTER*132
     *            lb, qb
      CHARACTER*7
     *            cplate, cdate, cdec
      CHARACTER*6
     *            cra, cfilt
      CHARACTER*5
     *            ctype, cha, ctime
      CHARACTER*3
     *            mon, monlist(12)
      CHARACTER*2
     *            emul
      INTEGER
     *            nlb, nident, err, id, expos, mm, dd, yy, f, nqb,
     *            rah, ram, decd, decm, uthh, utmm, hah, ham,
     *            cyy, cdn, j
      DOUBLE PRECISION
     *            ra2000, dec2000, ra, dec, ut, ep, ras, decs, dist,
     *            mra, mdec, p1ra, p1dec, p1djm, p1ut, p1ha, djm,
     *            oaz, ozd, oha, ara, adec, ora, odec, xi, eta, ha, dha
      DATA
     *            monlist/'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *                    'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
c
 9001 FORMAT (i6)
 9002 FORMAT (q, a)
 9003 FORMAT (i6, 3(1x,a), 1x,a, 1x,a, 2f10.0, 2(1x,a), 2x,i3,
     *        2x,a)
 9004 FORMAT (i2, a, i2)
 9005 FORMAT (2i2, f2.0)
 9006 FORMAT (i2, 1x, i2)
 9007 FORMAT (' SOUTH.CAT Out Of Order', i10)
 9008 FORMAT (i1, 1x, i2)
 9009 FORMAT (i3, 3f10.3, 4(1x, a))
c
c...Look In Catalog
c
  100 emul = 'SB'
      radian = 45.0D00/ATAN(1.0D00)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='scheck.out',
     *      status='unknown',
     *      unit=2
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/south.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002)
      DO f=1,NP2
        READ (1,9002) nlb,lb
        READ (lb(1:6),9001) id
        IF (id.ne.f) THEN
          WRITE (*,9007) id
      write (*,9991) id
 9991 format (' ID=', i10)
          CALL EXIT
        ENDIF
        READ (lb(1:nlb),9003) id,cplate,cdate,ctime,cra,cdec,
     *                        ra2000,dec2000,ctype,cfilt,expos,cha
        IF (emul.ne.cplate(1:2)) THEN
      write (*,9992) emul,ctype
 9992 format (2(' >>', a, '<<'))
          WRITE (*,9007) id
          CALL EXIT
        ENDIF
        READ (cdate,9004) dd,mon,yy
        yy = yy+1900
c
c...Parse Catalog Entry
c
        DO mm=1,12
          IF (monlist(mm).eq.mon) GO TO 110
        ENDDO
  110   READ (cra,9005) rah,ram,ras
        CALL sla_DTF2R(rah,ram,ras, ra,j)
        IF (j.ne.0) THEN
          write (*,9999) rah,ram,ras,j
 9999     format (' RA Error', 4i10)
          GO TO 200
        ENDIF
        READ (cdec(2:7),9005) decd,decm,decs
        CALL sla_DAF2R(decd,decm,decs, dec,j)
        IF (j.ne.0) THEN
          write (*,9998) decd,decm,decs,j
 9998     format (' Dec Error', 4i10)
          GO TO 200
        ENDIF
        IF (INDEX(cdec,'-').gt.0) THEN
          dec = -dec
        ENDIF
        READ (cha,9008) hah,ham
        CALL sla_DTF2R(hah,ham,0.0D00, ha,j)
        IF (j.ne.0) THEN
          write (*,9997) cha,hah,ham,j
 9997     format (' HA Error >>', a, '<<', 3i10)
          GO TO 200
        ENDIF
        IF (cha(5:5).eq.'E') THEN
          ha = -ha
        ENDIF
        ha = ha + (7.5D00*expos/60.0D00)/radian
        READ (ctime,9006) uthh,utmm
        ut = uthh + utmm/60.0D00 + expos/120.0D00
c
c...Precess To J2000 And Copy Into Common
c
        CALL sla_CALDJ(yy,mm,dd, p1djm,j)
        IF (j.ne.0) GO TO 200
        CALL sla_CALYD(yy,mm,dd, cyy,cdn,j)
        IF (j.ne.0) GO TO 200
        IF (MOD(yy,4).eq.0) THEN
          ep = cyy + (cdn + ut/24.0D00 - 1)/366.0D00
        ELSE
          ep = cyy + (cdn + ut/24.0D00 - 1)/365.0D00
        ENDIF
        p1ra = ra
        p1dec = dec
        p1ut = ut
        p1ha = ha
c
c...SLASETUP
c
        field_epoch = ep
        obs_scale = 67.18D00
        CALL sla_MAPPA(field_epoch,p1djm,amprms)
        mid_exp = p1djm + p1ut/24.0D00
        obs_long = (149.07D00)/radian
        obs_lat = (-31.27D00)/radian
        obs_elev = 1130.0D00
        obs_temp = 285.0D00
        obs_pres = 1013.25D00*EXP(-obs_elev/8149.9415D00)
        obs_humid = 0.25D00
        obs_emul = 256*ICHAR(emul(1:1)) + ICHAR(emul(2:2))
        IF ((emul.eq.'UJ').or.(emul.eq.'SJ').or.(emul.eq.'SB')) THEN
          obs_wave = 0.48D00
        ELSEIF ((emul.eq.'SF').or.(emul.eq.'SR')) THEN
          obs_wave = 0.65D00
        ELSEIF (emul.eq.'SN') THEN
          obs_wave = 0.85D00
        ELSEIF (emul.eq.'SO') THEN
          obs_wave = 0.41D00
        ELSEIF (emul.eq.'SE') THEN
          obs_wave = 0.65D00
        ELSE
          STOP 'EMULSION'
        ENDIF
        obs_tlr = 0.0065D00
        obs_tlr = 0.0065D00
        obs_xpolar = 0.0D00
        obs_ypolar = 0.0D00
        obs_dut = 0.0D00
        CALL sla_AOPPA(mid_exp, obs_dut, obs_long, obs_lat, obs_elev,
     *               obs_xpolar, obs_ypolar, obs_temp, obs_pres,
     *                 obs_humid, obs_wave, obs_tlr, aoprms)
c
c...Transform The Field Center
c
        CALL sla_MAPQKZ(p1ra,p1dec,amprms,field_ara,field_adec)
        CALL sla_AOPQK(field_ara,field_adec,aoprms,oaz,ozd,oha,
     *                  field_odec,field_ora)
        obs_unit = 3600.0D00*100000.0D00*radian/obs_scale
        obs_disco = -0.3333D00
c
c...Did It Work?
c
        dha = radian*(p1ha-oha)/15.0D00
        IF (ABS(dha).ge.0.25D00) THEN
          WRITE (2,9009) f,dha,p1ha,oha,cra,cdec,ctime,cha
        ENDIF
      ENDDO
      CLOSE (1)
      CLOSE (2)
      CALL EXIT
c
c...Fatal Errors
c
  200 STOP 'FATAL ERROR'
      END
