      SUBROUTINE  chkbox(mode)
c
c...Compute Means/Sigmas In Boxes.
c
c	Not Very General
c
c	WARNING.  This routine fakes the differential hole offset between
c		platens.  I just grabbed the mean from the new and improved
c		taff-o-grams and installed it here.  The GSC .RES file
c		approach does not (yet) include platen/hole information.
c
      INCLUDE
     *            'taff.inc'
      PARAMETER
     *            nbox = 33,
     *            boxwide = 10.0,
     *            firstbox = 0.0,
     *            nlmax = 50,
     *            holex = 1.46,
     *            holey = 3.06
      CHARACTER*6
     *            field(NBOX)
      REAL
     *            xxbox(NBOX,NBOX), sxbox(NBOX,NBOX), yybox(NBOX,NBOX),
     *            sybox(NBOX,NBOX), nnbox(NBOX,NBOX), xx, rx, yy, ry,
     *            x1, y1, x2, y2, level(NLMAX), l0, dl, zmin, zmax,
     *            t, t0, SECNDS, z
      INTEGER
     *            ix, iy, i, j, mode, nl
c
 9001 FORMAT (' Min=', f10.2, '   Max=', f10.2)
 9002 FORMAT (' Enter L0,DL,NL: ' $)
 9003 FORMAT (2f10.0,i10)
 9004 FORMAT (i3, '(', i1, ')')
 9005 FORMAT (17(1x,a))
 9006 FORMAT (2i3, i5, 4f10.2)
 9007 FORMAT (i1, 2f10.2)
c
c...Initialization
c
  100 DO iy=1,NBOX
        DO ix=1,NBOX
          xxbox(ix,iy) = 0.0
          sxbox(ix,iy) = 0.0
          yybox(ix,iy) = 0.0
          sybox(ix,iy) = 0.0
          nnbox(ix,iy) = 0.0
        ENDDO
      ENDDO
c
c...Summation.  Positions In MM, Residuals In Microns
c
      DO i=1,nstar
        xx = 0.00001*xpos(i) - HOLEX
        yy = 0.00001*ypos(i) - HOLEY
        rx =    0.01*xres(i)
        ry =    0.01*yres(i)
        ix = (xx-FIRSTBOX)/BOXWIDE + 1.0
        iy = (yy-FIRSTBOX)/BOXWIDE + 1.0
        IF  ((ix.ge.1).and.(ix.le.NBOX)
     *  .and.(iy.ge.1).and.(iy.le.NBOX)) THEN
          xxbox(ix,iy) = xxbox(ix,iy) + rx
          sxbox(ix,iy) = sxbox(ix,iy) + rx*rx
          yybox(ix,iy) = yybox(ix,iy) + ry
          sybox(ix,iy) = sybox(ix,iy) + ry*ry
          nnbox(ix,iy) = nnbox(ix,iy) + 1.0
        ENDIF
      ENDDO
c
c...Statistics
c
      DO iy=1,NBOX
        DO ix=1,NBOX
          i = nnbox(ix,iy)+0.5
          IF (i.le.0) THEN
            sxbox(ix,iy) = 0.0
            sybox(ix,iy) = 0.0
          ELSEIF (i.eq.1) THEN
            sxbox(ix,iy) = 0.0
            sybox(ix,iy) = 0.0
          ELSE
           xxbox(ix,iy) = xxbox(ix,iy)/nnbox(ix,iy)
           sxbox(ix,iy) = SQRT(sxbox(ix,iy)/nnbox(ix,iy)
     *                  - xxbox(ix,iy)*xxbox(ix,iy))
           yybox(ix,iy) = yybox(ix,iy)/nnbox(ix,iy)
           sybox(ix,iy) = SQRT(sybox(ix,iy)/nnbox(ix,iy)
     *                  - yybox(ix,iy)*yybox(ix,iy))
          ENDIF
        ENDDO
      ENDDO
c
c...Save
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='check.z',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,8
        WRITE (1,9007) i,HOLEX,HOLEY
      ENDDO
      DO iy=1,NBOX
        DO ix=1,NBOX
          nl = nnbox(ix,iy)
          WRITE (1,9006) ix,iy,nl,xxbox(ix,iy),sxbox(ix,iy),
     *                   yybox(ix,iy),sybox(ix,iy)
        ENDDO
      ENDDO
      CLOSE (1)
c
c...Limits
c
      zmin = MIN(xxbox(1,1),yybox(1,1))
      zmax = MAX(xxbox(1,1),yybox(1,1))
      DO iy=1,NBOX
        DO ix=1,NBOX
          zmin = MIN(zmin,xxbox(ix,iy),yybox(ix,iy))
          zmax = MAX(zmax,xxbox(ix,iy),yybox(ix,iy))
        ENDDO
      ENDDO
c
c...Plot If Desired
c
      IF (mode.ne.0) THEN
  110   WRITE (*,9001) zmin,zmax
        WRITE (*,9002)
        READ  (*,9003,err=110,end=200) l0,dl,nl
        IF ((nl.le.1).or.(nl.gt.NLMAX)) GO TO 110
        IF (dl.eq.0.0) GO TO 110
        DO i=1,nl
          level(i) = l0 + (i-1)*dl
        ENDDO
        CALL mgoinit
        CALL mgosetup(-7)
        x1 = 1.0
        x2 = NBOX
        y1 = 1.0
        y2 = NBOX
        CALL mgosetlim(x1,y1,x2,y2)
        CALL mgobox(1,1)
        CALL mgoxlabel(15,'Mean X Residual')
        CALL mgocontour(xxbox,NBOX,NBOX,level,nl)
        CALL mgoprntplot(i)
        t0 = SECNDS(0.0)
  120   t = SECNDS(t0)
        IF (t.le.5.0) GO TO 120
        CALL mgoerase
        CALL mgobox(1,1)
        CALL mgoxlabel(15,'Mean Y Residual')
        CALL mgocontour(yybox,NBOX,NBOX,level,nl)
        CALL mgoprntplot(i)
      ENDIF
      RETURN
c
c...Errors
c
  200 CALL EXIT
      END
