      PROGRAM  zplot
c
c...Recover a BOXES.Z File And Plot It
c
      INCLUDE
     *            'taff.inc'
      PARAMETER
     *            nbox = 17,
     *            boxwide = 20.0,
     *            firstbox = -5.0,
     *            nlmax = 50
      REAL
     *            xxbox(NBOX,NBOX), sxbox(NBOX,NBOX), yybox(NBOX,NBOX),
     *            sybox(NBOX,NBOX), nnbox(NBOX,NBOX), xx, rx, yy, ry,
     *            x1, y1, x2, y2, level(NLMAX), l0, dl, zmin, zmax,
     *            t, t0, SECNDS, z
      INTEGER
     *            ix, iy, i, j, mode, nl, nlb, ntb
      CHARACTER*64
     *            lb, tb
c
 9001 FORMAT (' Min=', f10.2, '   Max=', f10.2)
 9002 FORMAT (' Enter L0,DL,NL: ' $)
 9003 FORMAT (2f10.0,i10)
 9006 FORMAT (2i3, i5, 4f10.2)
 9007 FORMAT (' Enter BOXES.Z File: ' $)
 9008 FORMAT (q, a)
c
c...Load It
c
  100 WRITE (*,9007)
      READ  (*,9008,err=100) nlb,lb
      IF (nlb.le.0) THEN
        lb = 'boxes.z'
        nlb = 7
      ENDIF
      CALL f_doenv(lb(1:nlb),ntb,tb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO iy=1,NBOX
        DO ix=1,NBOX
          READ (1,9006) ix,iy,nl,xxbox(ix,iy),sxbox(ix,iy),
     *                   yybox(ix,iy),sybox(ix,iy)
          nnbox(ix,iy) = nl
        ENDDO
      ENDDO
      CLOSE (1)
c
c...Limits
c
      zmin = MIN(xxbox(1,1),yybox(1,1))
      zmax = MAX(xxbox(1,1),yybox(1,1))
      DO iy=1,NBOX
        DO ix=1,NBOX
          zmin = MIN(zmin,xxbox(ix,iy),yybox(ix,iy))
          zmax = MAX(zmax,xxbox(ix,iy),yybox(ix,iy))
        ENDDO
      ENDDO
c
c...Plot If Desired
c
  110 WRITE (*,9001) zmin,zmax
      WRITE (*,9002)
      READ  (*,9003,err=110) l0,dl,nl
      IF ((nl.le.1).or.(nl.gt.NLMAX)) GO TO 110
      IF (dl.eq.0.0) GO TO 110
      DO i=1,nl
        level(i) = l0 + (i-1)*dl
      ENDDO
      CALL mgoinit
      CALL mgosetup(-7)
      x1 = 1.0
      x2 = NBOX
      y1 = 1.0
      y2 = NBOX
      CALL mgosetlim(x1,y1,x2,y2)
      CALL mgobox(1,1)
      CALL mgoxlabel(15,'Mean X Residual')
      CALL mgocontour(xxbox,NBOX,NBOX,level,nl)
      CALL mgoprntplot(i)
      t0 = SECNDS(0.0)
  120 t = SECNDS(t0)
      IF (t.le.5.0) GO TO 120
      CALL mgoerase
      CALL mgobox(1,1)
      CALL mgoxlabel(15,'Mean Y Residual')
      CALL mgocontour(yybox,NBOX,NBOX,level,nl)
      CALL mgoprntplot(i)
      CALL EXIT
      END
