      SUBROUTINE  fit7
c
c...Least Squares Fit To Pairs
c
      INCLUDE
     *            'piece12.inc'
      DOUBLE PRECISION
     *            chisq, x, y, yy, yr, dx, dy
      INTEGER
     *            i, j, k, ncoef, ising, nin, w1, w2, w
c
 9001 FORMAT (' Singular Matrix In FIT7')
c
c...Initialization
c
  100 ncoef = 2
      DO i=1,ncoef
        zlhs(i) = 0.0D00
        coef(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
c
c...Accumulation
c
      DO i=1,np
        x = 0.01D00*px(i)
        y = 0.01D00*(py(i)-px(i))
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        DO j=1,ncoef
          zlhs(j) = zlhs(j) + dv(j)*y
          DO k=1,ncoef
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(ncoef,ising)
      IF (ising.ne.0) THEN
        stderr = -1.0D00
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          coef(i) = coef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals and Chi Sqaured
c
      DO i=1,np
        x = 0.01D00*px(i)
        y = 0.01D00*(py(i)-px(i))
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        yy = 0.0D00
        DO j=1,ncoef
          yy = yy + coef(j)*dv(j)
        ENDDO
        yr = y-yy
        chisq = chisq + yr*yr
      ENDDO
c
c...Errors
c
      i = MAX(1,np-(ncoef+1))
      stderr = SQRT(chisq/i)
      DO i=1,ncoef
        scoef(i) = stderr*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
