      SUBROUTINE  magprep(field,br,bs,bm,bv)
c
c...Ready For Search
c
      INCLUDE
     *            'piece12.inc'
      PARAMETER
     *            test = 180*3600*100,
     *            wrap = 360*3600*100,
     *            secwide = 120
      INTEGER
     *            srmin, srmax, sdmin, sdmax, i, j, r, field, br(*),
     *            crmin, crmax, cdmin, cdmax, dra, ddec, bs(*), bm(*),
     *            bv(*)
      DOUBLE PRECISION
     *            d
c
 9001 FORMAT (' Stars Are Out Of Order ', 3i12)
 9002 FORMAT (' All RAs Are Duplicates')
 9003 FORMAT (' Catalog/Field Overlap Error')
 9004 FORMAT (' Catalog ', 4i12)
 9005 FORMAT ('   Stars ', 4i12)
c
c...Sort according to RA with or without a wrap
c
  100 IF (fwrap(field).eq.0) THEN
        DO i=1,nb
          jdx(i) = i
        ENDDO
      ELSE
        DO i=1,nb
          IF ((br(i).ge.0).and.(br(i).lt.TEST)) THEN
            br(i) = br(i)+WRAP
          ENDIF
          jdx(i) = i
        ENDDO
      ENDIF
      CALL iuqsrt(nb,br,jdx)
      CALL ireord(nb,jdx,bs,tmp)
      CALL ireord(nb,jdx,bm,tmp)
      CALL ireord(nb,jdx,bv,tmp)
      srmin = br(1)
      srmax = br(nb)
      sdmin = bs(1)
      sdmax = bs(1)
      DO i=2,nb
        sdmin = MIN(sdmin,bs(i))
        sdmax = MAX(sdmax,bs(i))
      ENDDO
c
c...Verify That Catalog Limits Makes Sense
c
      crmin = frmin(field)
      crmax = frmax(field)
      cdmin = fdmin(field)
      cdmax = fdmax(field)
      IF ((crmin.gt.srmin).or.(crmax.lt.srmax)
     *.or.(cdmin.gt.sdmin).or.(cdmax.lt.sdmax)) THEN
        WRITE (*,9003)
        WRITE (*,9004) crmin,crmax,cdmin,cdmax
        WRITE (*,9005) srmin,srmax,sdmin,sdmax
        CALL EXIT
      ENDIF
c
c...Tighten Up Catalog Extraction Limits
c
      d = (sdmin+sdmax)/(2.0D00*3600.0D00*100.0D00) - 90.0D00
      dra = SECWIDE*100.0/COSD(d)
      ddec = SECWIDE*100.0
      crmin = srmin - dra
      crmax = srmax + dra
      cdmin = sdmin - ddec
      cdmax = sdmax + ddec
c
c...Extract Our Piece Of The Catalog
c
      CALL getbegin(srmin,j)
      nq = 0
      DO i=j,nc
        IF (cra(i).gt.crmax) GO TO 120
        IF ((cdec(i).ge.cdmin).and.(cdec(i).le.cdmax)) THEN
          nq = nq+1
          qra(nq) = cra(i)
          qdec(nq) = cdec(i)
          qmag(nq) = cmag(i)
          IF (nq.ge.NPMAX) GO TO 140
        ENDIF
      ENDDO
  120 IF (fwrap(field).ne.0) THEN
        DO i=1,j
          r = cra(i)+WRAP
          IF (r.gt.crmax) GO TO 130
          IF ((cdec(i).ge.cdmin).and.(cdec(i).le.cdmax)) THEN
            nq = nq+1
            qra(nq) = r
            qdec(nq) = cdec(i)
            qmag(nq) = cmag(i)
            IF (nq.ge.NPMAX) GO TO 140
          ENDIF
        ENDDO
  130   CONTINUE
      ENDIF
  140 CONTINUE
      RETURN
      END
