      SUBROUTINE  setup
c
c...Initialize Various Parameters
c
      INCLUDE
     *            'piece12.inc'
      INTEGER
     *            i, j, k, n, l, nlb
      REAL
     *            m
      CHARACTER*64
     *            lb
c
 9001 FORMAT (i4, 1x, f5.2)
 9002 FORMAT (i3, 1x, i3, 1x, i3)
c
c...Control Initializations
c
      write (*,9991)
 9991 format (' LIMITMAG is 17th!')
  100 minqual = 2
      duprad = 1.0D00
      DO i=1,180
        cd(i) = COSD(i-90.5D00)
      ENDDO
c
c...Limiting Magnitude Initialization
c
      CALL f_doenv('LISTS:limit.mag',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NFIELD
        READ (1,9001) l,m
        IF (l.ne.i) THEN
          STOP 'LIMIT'
        ENDIF
        limitmag(i) = 100.0*m + 0.5
 9999 limitmag(i) = 1700
      ENDDO
      CLOSE (1)
c
c...Ring Initialization
c
      DO i=1,NRING
        rid(i) = -1
      ENDDO
      CALL f_doenv('HOME:binary/piece12/rings.dat',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      n = 0
  110 READ (1,9002,err=110,end=120) i,j,k
      n = n+1
      rid(n) = i
      rf(n) = j
      rl(n) = k
      IF (n.lt.NRING) GO TO 110
  120 CLOSE (1)
c
c...Open File For Messages
c
      CALL f_doenv('HOME:binary/piece12/piece12.log',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=10
     *     )
      RETURN
      END
