      SUBROUTINE  sortit(z)
c
c...Northern Zones (170,175) Are Too Wide For 2-Input PIECE2.  This
c	Routine Sorts These Zones The Hard Way.  Should Be OK Since
c	Solid Angle Is Small
c
      INCLUDE
     *         'piece12.inc'
      INTEGER
     *         z, nlb, i, n, nr
      CHARACTER*64
     *         lb
      CHARACTER*3
     *         cz
c
 9001 FORMAT (i3.3)
 9002 FORMAT (i10)
 9003 FORMAT (' No Space For Zone=', i3, 2i12)
 9004 FORMAT (' Cannot Open ', a)
 9005 FORMAT (' Sorting Zone ', i3)
c
c...Get Zone And Count
c
  100 WRITE (cz,9001) z
      CALL f_doenv('MERGES:ring'//cz//'.hdr',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002) n
      CLOSE (1)
      IF (n.gt.NSMAX) THEN
        WRITE (*,9003) z,n,NSMAX
        WRITE (10,9003) z,n,NSMAX
        RETURN
      ENDIF
      WRITE (*,9005) z
      WRITE (10,9005) z
      nr = 3*n
c
c...Get Data
c
      lb(nlb-2:nlb) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=nr,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (svec(i),i=1,nr)
      CLOSE (1)
c
c...Copy And Sort On RA
c
      DO i=1,n
        sidx(i) = i
        stmp(i) = sbuf(1,i)
      ENDDO
      CALL iuqsrt(n,stmp,sidx)
      DO i=1,n
        sbuf(1,i) = stmp(i)
      ENDDO
c
c...ReOrder SPD
c
      DO i=1,n
        stmp(i) = sbuf(2,i)
      ENDDO
      DO i=1,n
        sbuf(2,i) = stmp(sidx(i))
      ENDDO
c
c...ReOrder MAG
c
      DO i=1,n
        stmp(i) = sbuf(3,i)
      ENDDO
      DO i=1,n
        sbuf(3,i) = stmp(sidx(i))
      ENDDO
c
c...Save
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      recl=nr,
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      WRITE (1,rec=1) (svec(i),i=1,nr)
      CLOSE (1)
      RETURN
c
c...Errors
c
  200 WRITE (*,9004) lb(1:nlb)
      WRITE (10,9004) lb(1:nlb)
      RETURN
      END
