      PROGRAM  checkzone
c
c...Make Sure Zones Increase In RA
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 8*1024*1024
      INTEGER
     *         i, j, k, n, zone, buf(3,NMAX), vec(3*NMAX), nlb, nr,
     *         smin, smax, nomit, mmin, mmax
      REAL
     *         x
      CHARACTER*64
     *         lb
      CHARACTER*4
     *         cz
      EQUIVALENCE
     *         (buf(1,1),vec(1))
c
 9001 FORMAT (i4.4)
 9002 FORMAT (f5.3, 2i12)
 9003 FORMAT (' Enter Zone: ' $)
 9004 FORMAT (i10)
 9005 FORMAT (' No Space ', 2i12)
 9006 FORMAT (' RA Error At I=', 3i12)
 9007 FORMAT (' SMin=', i12, '   SMax=', i12)
 9008 FORMAT (' Already Omitted ', 3i12)
c
c...Get Zone And Count ACC
c
  100 WRITE (*,9003)
      READ  (*,9004) zone
      WRITE (cz,9001) zone
      CALL f_doenv('MERGES:zone'//cz//'.acc',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=100,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      n = 0
      DO i=1,96
        READ (1,9002) x,j,k
        n = n+k
      ENDDO
      CLOSE (1)
      IF (n.gt.NMAX) THEN
        WRITE (*,9005) n,NMAX
        CALL EXIT
      ENDIF
c
c...Read CAT File
c
      nr = n*3
      lb(nlb-2:nlb) = 'cat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=nr,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (vec(i),i=1,nr)
      CLOSE (1)
c
c...Check It
c
      smin = buf(2,1)
      smax = buf(2,1)
      nomit = 0
      mmin = buf(3,1)
      mmax = buf(3,1)
      DO i=1,n-1
        IF (buf(1,i).gt.buf(1,i+1)) THEN
          WRITE (*,9006) i,buf(1,i),buf(1,i+1)
          PAUSE
        ENDIF
        smin = MIN(smin,buf(2,i))
        smax = MAX(smax,buf(2,i))
        IF (buf(3,i).lt.0) THEN
      write (*,9999) i,buf(1,i),buf(2,i),buf(3,i)
      write (*,9998) buf(3,i)
      pause
 9999 format (4i12)
 9998 format (z12)
          nomit = nomit+1
        ELSE
          mmin = MIN(mmin,buf(3,i))
          mmax = MAX(mmax,buf(3,i))
        ENDIF
      ENDDO
      WRITE (*,9007) smin,smax
      WRITE (*,9008) nomit,mmin,mmax
      CALL EXIT
      END
