      SUBROUTINE  fitmag
c
c...Least Squares Fit To Overlaps
c
      INCLUDE
     *            'postmag.inc'
      DOUBLE PRECISION
     *            chisq, x, y, yy, yr
      INTEGER
     *            i, j, k, ising
c
c...Initialization
c
  100 DO i=1,ncoef
        zlhs(i) = 0.0D00
        coef(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      nin = 0
c
c...Accumulation
c
      DO i=1,no
        IF (ino(i).ne.0) THEN
          x = xo(i)
          y = yo(i)
          dv(1) = 1.0D00
          DO j=2,ncoef
            dv(j) = dv(j-1)*x
          ENDDO
          DO j=1,ncoef
            zlhs(j) = zlhs(j) + dv(j)*y
            DO k=1,ncoef
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nin = nin+1
        ENDIF
      ENDDO
c
c...Inversion
c
      IF (nin.le.(ncoef+2)) THEN
        stderr = -1.0D00
        RETURN
      ENDIF
      CALL matinv(ising)
      IF (ising.ne.0) THEN
        stderr = -2.0D00
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          coef(i) = coef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals and Chi Sqaured
c
      nin = 0
      DO i=1,no
        x = xo(i)
        y = yo(i)
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        yy = 0.0D00
        DO j=1,ncoef
          yy = yy + coef(j)*dv(j)
        ENDDO
        yr = y-yy
        IF (ino(i).ne.0) THEN
          chisq = chisq + yr*yr
          nin = nin+1
        ENDIF
        ro(i) = yr
      ENDDO
c
c...Errors
c
      stderr = SQRT(chisq/(nin-(ncoef+1)))
      DO i=1,ncoef
        scoef(i) = stderr*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
