      SUBROUTINE  getpost
c
c...Recover the POSTMAG File
c
      INCLUDE
     *            'adjust.inc'
      INTEGER
     *            nlb, ntb, f1, f2, i
      CHARACTER*64
     *            lb, tb
      DOUBLE PRECISION
     *            stderr, const
c
 9001 FORMAT (' Enter POSTMAG File [postmag.out]: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (1x, 2(1x,i4), 10x, 1x,f4.0, 1x,1pe10.3)
 9005 FORMAT (' Recovered ', i6, ' Overlaps')
c
c...Get File And Open It
c
  100 WRITE (*,9001)
      READ  (*,9002,err=100,end=210) nlb,lb
      IF (nlb.le.0) THEN
        nlb = 11
        lb(1:nlb) = 'postmag.out'
      ENDIF
      CALL f_doenv(lb(1:nlb),ntb,tb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nlist = 0
c
c...Ingest The File
c
  110 READ (1,9004,err=110,end=120) f1,f2,stderr,const
      IF (stderr.le.0.0D00) GO TO 110
      nlist = nlist+1
      f1list(nlist) = f1
      f2list(nlist) = f2
      wgtlist(nlist) = 1.0D00/(stderr*stderr)
      conlist(nlist) = const
      GO TO 110
  120 CLOSE (1)
      WRITE (*,9005) nlist
c
c...Other Initializations
c
      DO i=1,NFMAX
        param(i) = 0.0D00
      ENDDO
      RETURN
c
c...Errors
c
  200 WRITE (*,9003) tb(1:ntb)
      GO TO 100
  210 CALL EXIT
      END
