      SUBROUTINE  lsodditer(mean,worst)
c
c...Assume Mean Mags Are Known And Solve For Deltas
c
      INCLUDE
     *            'lsiterate.inc'
      INTEGER
     *            i, f, n, mean, worst, j, fmin, fmax, k, nfree, ising
      DOUBLE PRECISION
     *            x, y, yc, yr
c
c...Initialization
c
  100 DO f=1,NFMAX
        sn(f) = 0
        dold(f) = delta(f)
        delta(f) = 0
        edelta(f) = 0
        chisq(f) = 0.0D00
        stderr(f) = 0.0D00
        DO j=1,25
          maghist(j,f) = 0
        ENDDO
        DO j=1,ncoef
          coef(j,f) = 0.0D00
          scoef(j,f) = 0.0D00
          zlhs(j,f) = 0.0D00
          DO k=1,ncoef
            zrhs(j,k,f) = 0.0D00
          ENDDO
        ENDDO
      ENDDO
      fmin = 100.0D00*minmag + 0.5D00
      fmax = 100.0D00*maxmag + 0.5D00
c
c...Accumulation
c
      DO i=1,nlist
        IF  ((infit(i).ne.0)
     *  .and.(m1(i).ge.fmin).and.(m1(i).lt.fmax)
     *  .and.(m2(i).ge.fmin).and.(m2(i).lt.fmax)) THEN
c
c...(F1)
c
          f = f1(i)
          x = m1(i)
          y = mbar(i)
          dv(1) = 1.0D00
          DO j=2,ncoef
            dv(j) = dv(j-1)*x
          ENDDO
          DO j=1,ncoef
            zlhs(j,f) = zlhs(j,f) + y*dv(j)
            DO k=1,ncoef
              zrhs(j,k,f) = zrhs(j,k,f) + dv(j)*dv(k)
            ENDDO
          ENDDO
          sn(f) = sn(f)+1
          j = MAX(1,MIN(25,m1(i)/100))
          maghist(j,f) = maghist(j,f)+1
c
c...(F2)
c
          f = f2(i)
          x = m2(i)
          y = mbar(i)
          dv(1) = 1.0D00
          DO j=2,ncoef
            dv(j) = dv(j-1)*x
          ENDDO
          DO j=1,ncoef
            zlhs(j,f) = zlhs(j,f) + y*dv(j)
            DO k=1,ncoef
              zrhs(j,k,f) = zrhs(j,k,f) + dv(j)*dv(k)
            ENDDO
          ENDDO
          sn(f) = sn(f) + 1
          j = MAX(1,MIN(25,m2(i)/100))
          maghist(j,f) = maghist(j,f)+1
        ENDIF
      ENDDO
c
c...Compute Coefficients
c
      DO f=1,NFMAX
        nfree = sn(f)-(ncoef+1)
        IF (nfree.le.1) THEN
          sn(f) = -1
        ELSE
          CALL lsmatinv(zrhs(1,1,f),ising)
          IF (ising.ne.0) THEN
            sn(f) = -2
          ELSE
            DO j=1,ncoef
              DO k=1,ncoef
                coef(j,f) = coef(j,f) + zrhs(j,k,f)*zlhs(k,f)
              ENDDO
            ENDDO
          ENDIF
        ENDIF
      ENDDO
c
c...Residuals And Chi Squared
c
      DO i=1,nlist
        IF  ((infit(i).ne.0)
     *  .and.(m1(i).ge.fmin).and.(m1(i).lt.fmax)
     *  .and.(m2(i).ge.fmin).and.(m2(i).lt.fmax)) THEN
c...(F1)
c
          f = f1(i)
          x = m1(i)
          y = mbar(i)
          dv(1) = 1.0D00
          DO j=2,ncoef
            dv(j) = dv(j-1)*x
          ENDDO
          yc = 0.0D00
          DO j=1,ncoef
            yc = yc + dv(j)*coef(j,f)
          ENDDO
          yr = y-yc
          chisq(f) = chisq(f) + yr*yr
c
c...(F2)
c
          f = f2(i)
          x = m2(i)
          y = mbar(i)
          dv(1) = 1.0D00
          DO j=2,ncoef
            dv(j) = dv(j-1)*x
          ENDDO
          yc = 0.0D00
          DO j=1,ncoef
            yc = yc + dv(j)*coef(j,f)
          ENDDO
          yr = y-yc
          chisq(f) = chisq(f) + yr*yr
        ENDIF
      ENDDO
c
c...Errors
c
      DO f=1,NFMAX
        IF (sn(f).gt.0) THEN
          nfree = MAX(1,sn(f)-(ncoef+1))
          stderr(f) = SQRT(chisq(f)/nfree)
          DO j=1,ncoef
            scoef(j,f) = stderr(f)*SQRT(zrhs(j,j,f))
          ENDDO
          delta(f) = coef(1,f)
          edelta(f) = scoef(1,f)
        ENDIF
      ENDDO
c
c...Simple Statistics
c
      worst = 0
      mean = 0
      n = 0
      DO f=1,NFMAX
        IF (sn(f).gt.0) THEN
          j = ABS(delta(f)-dold(f))
          worst = MAX(worst,j)
          mean = mean+j
          n = n+1
        ENDIF
      ENDDO
      mean = mean/n
      write (*,9991) n,mean,worst
 9991 format (3i10)
      RETURN
      END
