      SUBROUTINE  lssaveit
c
c...Save Output From Iteration
c
      INCLUDE
     *            'lsiterate.inc'
      INTEGER
     *            i, j
      DOUBLE PRECISION
     *            d, e, snr, q
c
 9001 FORMAT (i5, 2f10.2, i10, f10.1, f10.3)
 9002 FORMAT (20i6)
c
c...Solution Parameters
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='lsiterate.out',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,NFMAX
        IF (sn(i).gt.0) THEN
          d = 0.01D00*delta(i)
          e = 0.01D00*edelta(i)
          snr = ABS(d)/MAX(e,0.01D00)
          q = e/SQRT(DBLE(sn(i)))
          WRITE (1,9001) i,d,e,sn(i),snr,q
        ENDIF
      ENDDO
      CLOSE (1)
c
c...Debugging Information
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='lsiterate.hst',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,NFMAX
        IF (sn(i).gt.0) THEN
          WRITE (1,9002) i,(maghist(j,i),j=6,18)
        ENDIF
      ENDDO
      CLOSE (1)
      RETURN
      END
