      SUBROUTINE  xapfill(field,mbar,msig)
c
c...Fit Overlapping Bins
c
      INCLUDE
     *            'xmagapply.inc'
      INTEGER
     *            field, mbar(*), msig(*), i, j, k, nfree, ising
      DOUBLE PRECISION
     *            x, y, yc, yr, w, sumw
c
 9001 FORMAT (i5, f6.1, 8(1x,1pe11.4))
c
c...Count Free Parameters And Exit If Too Few
c
  100 nfree = -(ncoef+1)
      DO i=1,nbin
        IF (msig(i).ge.0) THEN
          nfree = nfree+1
        ENDIF
      ENDDO
      IF (nfree.lt.2) RETURN
c
c...Initialization
c
      DO i=1,ncoef
        coef(i,field) = 0.0D00
        scoef(i,field) = 0.0D00
        zlhs(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      stderr(field) = 0.0D00
      sumw = 0.0D00
c
c...Accumulation
c
      DO i=1,nbin
        x = binmag(i)
        y = mbar(i)
        w = MAX(1,msig(i))
        w = 1.0D00/(w*w)
 9999   w = 1.0D00
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        DO j=1,ncoef
          zlhs(j) = zlhs(j) + y*dv(j)*w
          DO k=1,ncoef
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)*w
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL xmatinv(ising)
      IF (ising.ne.0) RETURN
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          coef(i,field) = coef(i,field) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,nbin
        x = binmag(i)
        y = mbar(i)
        w = MAX(1,msig(i))
        w = 1.0D00/(w*w)
 9998   w = 1.0D00
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        yc = 0.0D00
        DO j=1,ncoef
          yc = yc + coef(j,field)*dv(j)
        ENDDO
        yr = y-yc
        chisq = chisq + w*yr*yr
        sumw = sumw+w
      ENDDO
c
c...Errors
c
      stderr(field) = SQRT((nbin*chisq)/(nfree*sumw))
      DO i=1,ncoef
        scoef(i,field) = stderr(field)*SQRT(zrhs(i,i))
      ENDDO
      WRITE (8,9001) field,stderr(field),(coef(i,field),scoef(i,field),
     *               i=1,ncoef)
      dofield(field) = 1
      RETURN
      END
