      PROGRAM  debug
c
c...Just A Debugger
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 500
      INTEGER
     *         nold, iold(NMAX), rold(NMAX), sold(NMAX), mold(NMAX),
     *         nnew, inew(NMAX), rnew(NMAX), snew(NMAX), mnew(NMAX),
     *         i
c
 9001 FORMAT (i10)
c
c...Get Old
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uw5/xpmm/lists/pat0101.inf',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) nold
      CLOSE (1)
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='/uw5/xpmm/lists/pat0101.dat',
     *      readonly,
     *      recl=nold,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec= 1) (iold(i),i=1,nold)
      READ (1,rec= 4) (mold(i),i=1,nold)
      READ (1,rec= 9) (rold(i),i=1,nold)
      READ (1,rec=10) (sold(i),i=1,nold)
      CLOSE (1)
      DO i=1,nold
        mold(i) = MOD(mold(i),10000)
      ENDDO
c
c...Get New
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='glop.inf',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) nnew
      CLOSE (1)
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='glop.dat',
     *      readonly,
     *      recl=nnew,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec= 1) (inew(i),i=1,nnew)
      READ (1,rec= 4) (mnew(i),i=1,nnew)
      READ (1,rec= 9) (rnew(i),i=1,nnew)
      READ (1,rec=10) (snew(i),i=1,nnew)
      CLOSE (1)
      DO i=1,nnew
        mnew(i) = MOD(mnew(i),10000)
      ENDDO
c
c...See What We Have
c
      write (*,9991) nold,nnew
      do i=1,10
      write (*,9991)
      write (*,9991) iold(i),rold(i),sold(i),mold(i)
      write (*,9991) inew(i),rnew(i),snew(i),mnew(i)
      enddo
 9991 format (4i12)
      CALL EXIT
      END
