      PROGRAM  genppm
c
c...Read PPM North Catalog And Sort On RA
c
c	NOTE:  Uses same units as TYCHO
c
      INCLUDE
     *          'possppm.inc'
      PARAMETER
     *          spd = (90*3600*100)
      CHARACTER*133
     *          lb
      CHARACTER*5
     *          note, cb
      CHARACTER*2
     *          sp
      CHARACTER*1
     *          sd, obafgkm(7), subtype(9)
      INTEGER
     *          i, id, r, d, m, ispec, j, put, kill, nn, k, dlim
      DOUBLE PRECISION
     *          rh, rm, rs, dd, dm, ds, mag, pmra, pmdec, x, y
      REAL
     *          vmag, bmag, bmv(70), jmag
      DATA
     *         obafgkm/'O','B','A','F','G','K','M'/,
     *         subtype/'1','2','3','4','5','6','7','8','9'/
      DATA
     * bmv/-0.37,-0.37,-0.36,-0.36,-0.35,-0.35,-0.34,-0.33,-0.32,-0.31,
     *     -0.28,-0.25,-0.22,-0.19,-0.16,-0.12,-0.09,-0.06,-0.03, 0.00,
     *      0.03, 0.06, 0.09, 0.11, 0.13, 0.15, 0.18, 0.21, 0.24, 0.27,
     *      0.30, 0.33, 0.36, 0.39, 0.42, 0.45, 0.48, 0.51, 0.54, 0.58,
     *      0.60, 0.63, 0.65, 0.68, 0.70, 0.73, 0.77, 0.81, 0.85, 0.90,
     *      0.95, 1.00, 1.06, 1.12, 1.18, 1.23, 1.28, 1.33, 1.39, 1.45,
     *      1.49, 1.54, 1.57, 1.60, 1.63, 1.68, 1.74, 1.80, 1.80, 1.80/
c
 9001 FORMAT (i6, 13x, f4.1, 1x, a, 1x, f2.0, 1x, f2.0, 1x, f6.3,
     *        2x, a, f2.0, 1x, f2.0, 1x, f5.2, 2x, f7.4, 1x, f6.3,
     *        57x, a)
 9002 FORMAT (a)
 9003 FORMAT (' Total Useful Records=', i10)
c
c...Outer Loop Over Catalogs
c
  100 put = 0
      dlim = 100.0D00*3600.0D00*DECLIMIT
      DO k=1,2
        IF (k.eq.1) THEN
          cb = 'NORTH'
          nn = NPPMN
        ELSE
          cb = 'SOUTH'
          nn = NPPMS
        ENDIF
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='/uz6/xpmm/sg5/tycho/PPM'//cb//'.DAT',
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        DO i=1,nn
          READ (1,9002) lb
          READ (lb,9001) id,mag,sp,rh,rm,rs,sd,dd,dm,ds,pmra,pmdec,note
          kill = 0
          IF (INDEX(note,'D').gt.0) kill = kill + 8
          IF (INDEX(note,'C').gt.0) kill = kill + 4
          IF (INDEX(note,'P').gt.0) kill = kill + 2
          IF (INDEX(note,'F').gt.0) kill = kill + 1
          DO j=1,7
            IF (sp(1:1).eq.obafgkm(j)) THEN
              ispec = 10*(j-1)
              GO TO 110
            ENDIF
          ENDDO
          kill = kill + 16
  110     DO j=1,9
            IF (sp(2:2).eq.subtype(j)) THEN
              ispec = ispec + j
              GO TO 120
            ENDIF
          ENDDO
          ispec = ispec + 4
c
c...Now Select Only Well Defined Stars
c
  120     IF (kill.le.1) THEN
            IF (kill.eq.1) THEN
              vmag = mag
              bmag = vmag + bmv(ispec)
            ELSE
              bmag = mag
              vmag = bmag - bmv(ispec)
            ENDIF
            jmag = vmag + 0.72*(bmag-vmag)
            r = 1500.0D00*(   (rh)*3600.0D00+rm*60.0D00+rs)+0.5D00
            d =  100.0D00*(ABS(dd)*3600.0D00+dm*60.0D00+ds)+0.5D00
            IF (sd.eq.'-') THEN
              d = -d
            ENDIF
            IF (d.ge.dlim) THEN
              m = 100.0D00*jmag + 0.5D00
              x = 15000.0D00*pmra*COSD(d/360000.0D00)
              y =  1000.0D00*pmdec
              put = put+1
              ppmid(put) = id
              ra10mas(put) = r
              spd10mas(put) = d+SPD
              v10mmag(put) = m
              bmv10mmag(put) = 100.0*(bmag-vmag)
              mux1mas(put) = x
              muy1mas(put) = y
            ENDIF
          ENDIF
        ENDDO
        CLOSE (1)
      ENDDO
c
c...Sort And ReOrder
c
      DO i=1,put
        idx(i) = i
      ENDDO
      CALL iuqsrt(put,ra10mas,idx)
      CALL ireord(put,idx,spd10mas,tmp)
      CALL ireord(put,idx, v10mmag,tmp)
      CALL ireord(put,idx,   ppmid,tmp)
      CALL ireord(put,idx, mux1mas,tmp)
      CALL ireord(put,idx, muy1mas,tmp)
      CALL ireord(put,idx,bmv10mmag,tmp)
c
c...Save As A Direct Access File
c
      OPEN (
     *       access='direct',
     *       carriagecontrol='none',
     *       convert='big_endian',
     *       dispose='keep',
     *       form='unformatted',
     *       name='/uz6/xpmm/sg5/tycho/ppm.srt',
     *       recl=put,
     *       recordtype='fixed',
     *       status='unknown',
     *       unit=1
     *      )
      WRITE (1,rec=1) (ppmid(i),i=1,put)
      WRITE (1,rec=2) (ra10mas(i),i=1,put)
      WRITE (1,rec=3) (spd10mas(i),i=1,put)
      WRITE (1,rec=4) (v10mmag(i),i=1,put)
      WRITE (1,rec=5) (mux1mas(i),i=1,put)
      WRITE (1,rec=6) (muy1mas(i),i=1,put)
      WRITE (1,rec=7) (bmv10mmag(i),i=1,put)
      CLOSE (1)
      WRITE (*,9003) put
      CALL EXIT
      END
