      SUBROUTINE  getover(fatal)
c
c...See If These Plates Overlap
c
      INCLUDE
     *            'jfoeproc.inc'
      INTEGER
     *            fatal, p1, p2, y, m, d, cyy, cdn, j
      DOUBLE PRECISION
     *            ra1, dec1, ra2, dec2, t, e, j2000, ra, de, b1950,
     *            djm, oaz, ozd, oha, ora, odec, xi, eta, zero
c
 9001 FORMAT ('POSS2=', i3, '  POSS1=', i4, '  Xi=', f10.6,
     *        '  Eta=', f10.6, '  Tol=', f10.6)
c
c...Simple Sanity Test Makes Sure This Field Is In Catalog
c
  100 p1 = request(3)
      IF (possmm(p1,3).le.0) THEN
        fatal = 7
        RETURN
      ENDIF
      p2 = request(1)
      IF (possmm(p2,1).eq.0) THEN
        fatal = 8
        RETURN
      ENDIF
c
c...POSS-II Coordinates Are At Epoch Of Observation.  Get J2000
c
      ra2 = possra(p2,1)
      dec2 = possdec(p2,1)
      y = possyy(p2,1)
      m = possmm(p2,1)
      d = possdd(p2,1)
      t = possut(p2,1)
      CALL sla_CALYD(y,m,d, cyy,cdn,j)
      IF (j.ne.0) THEN
        fatal = 9
        RETURN
      ENDIF
      IF (MOD(cyy,4).eq.0) THEN
        e = cyy + (cdn + t/24.0D00 - 1.0D00)/366.0D00
      ELSE
        e = cyy + (cdn + t/24.0D00 - 1.0D00)/365.0D00
      ENDIF
      j2000 = 2000.0D00
      CALL sla_PRECES('FK5',e,j2000, ra2,dec2)
c
c...POSS-I Coordinates Are At B1950.  Get J2000
c
      ra = possra(p1,3)
      de = possdec(p1,3)
      b1950 = 1950.0D00
      CALL sla_FK45Z(ra,de,b1950, ra1,dec1)
c
c...Sanity Test
c
      IF (ABS(dec1-dec2).ge.(7.0D00/radian)) THEN
        fatal = 17
        RETURN
      ENDIF
c
c...Get XI/ETA Of (RA1/DEC1) Assuming A Field Center Of (RA2/DEC2)
c
      obs_long = -(116.0D00 + 51.8D00/60.0D00)/radian
      obs_lat = (33.0D00 + 21.4D00/60.0D00)/radian
      obs_elev = 1706.0D00
      obs_temp = 285.0D00
      obs_pres = 1013.25D00*EXP(-obs_elev/8149.9415D00)
      obs_humid = 0.25D00
      obs_tlr = 0.0065D00
      obs_xpolar = 0.0D00
      obs_ypolar = 0.0D00
      obs_dut = 0.0D00
      obs_wave = 0.48D00
      y = possyy(p2,1)
      m = possmm(p2,1)
      d = possdd(p2,1)
      CALL sla_CALDJ(y,m,d, djm,j)
      IF (j.ne.0) THEN
        fatal = 10
        RETURN
      ENDIF
      CALL sla_MAPPA(j2000,djm,amprms)
      e = djm + possut(p2,1)/24.0D00
      CALL sla_AOPPA(e, obs_dut, obs_long, obs_lat, obs_elev,
     *               obs_xpolar, obs_ypolar, obs_temp, obs_pres,
     *               obs_humid, obs_wave, obs_tlr, aoprms)
      CALL sla_MAPQKZ(ra2,dec2,amprms, ra,de)
      CALL sla_AOPQK(ra,de,aoprms, oaz,ozd,oha, obs_dec0,obs_ra0)
      zero = 0.0D00
      CALL sla_MAPQK(ra1,dec1, zero,zero,zero,zero,amprms, ra,de)
      CALL sla_AOPQK(ra,de,aoprms, oaz,ozd,oha, odec,ora)
      CALL sla_DS2TP(ora,odec,obs_ra0,obs_dec0,xi,eta,j)
      IF (j.ne.0) THEN
        fatal = 11
        RETURN
      ENDIF
      CALL sla_PCD(obs_disco,xi,eta)
c
c...Is This Reasonable?
c
      t = SLA_WIDE/obs_unit
      IF (MAX(ABS(xi),ABS(eta)).gt.t) THEN
        fatal = 6
        RETURN
      ENDIF
      obs_dxi = obs_unit*xi
      obs_deta = obs_unit*eta
      WRITE (*,9001) p2,p1,xi,eta,t
      RETURN
      END
