      SUBROUTINE  pairfind(w1,w2)
c
c...Look In Sorted Lists For Pairs
c
      INCLUDE
     *            'jfoeproc.inc'
      PARAMETER
     *            npmax = 100
      INTEGER
     *            get, low, high, r, xl, xh, nfind, w1, w2, np,
     *            ifind(NPMAX), jfind(NPMAX), test, yl, yh, yt, j,
     *            n1, n2
      DOUBLE PRECISION
     *            dx, dy, dr, rfind(NPMAX), z, rsqr
c
c...Initialization
c
  100 get = 0
      np = 0
      npair(w2) = 0
      low = 1
      high = 1
      r = rmicron(w2)*100.0D00 + 0.5D00
      rsqr = (r/SCALE)**2
      n1 = nraw(w1)
      n2 = nraw(w2)
c
c...Outer Loop Over W1 Index
c
  110 get = get+1
      IF (get.gt.n1) THEN
        RETURN
      ENDIF
      IF (iraw(get,w1).le.0) GO TO 110
      xl = xraw(get,w1) - r
      xh = xraw(get,w1) + r
      yl = yraw(get,w1) - r
      yh = yraw(get,w1) + r
c
c...Inner Loop Brackets W2
c
  120 CONTINUE
      IF (xhat(low).lt.xl) THEN
        IF (low.lt.n2) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (xhat(low).gt.xh) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 CONTINUE
      IF (high.lt.n2) THEN
        IF (xhat(high+1).le.xh) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Test All Unique Entries In This Range
c
      nfind = 0
      DO test=low,high
        j = idx(test)
        IF (iraw(j,w2).gt.0) THEN
          yt = yhat(test)
          IF ((yt.ge.yl).and.(yt.le.yh)) THEN
            dy = ((yt-yraw(get,w1))/SCALE)**2
            IF (dy.le.rsqr) THEN
              dx = ((xhat(test)-xraw(get,w1))/SCALE)**2
              dr = dx+dy
              IF (dr.le.rsqr) THEN
                IF (nfind.lt.NPMAX) THEN
                  nfind = nfind+1
                  ifind(nfind) = get
                  jfind(nfind) = j
                  rfind(nfind) = ABS(mraw(get,w1)-mraw(j,w2))
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Save Pairs
c
      IF (nfind.gt.0) THEN
        np = np+1
        pair(np,w1) = ifind(1)
        pair(np,w2) = jfind(1)
        z = rfind(1)
        DO test=2,nfind
          IF (rfind(test).lt.z) THEN
            pair(np,w1) = ifind(test)
            pair(np,w2) = jfind(test)
            z = rfind(test)
          ENDIF
        ENDDO
        npair(w2) = np
      ENDIF
c
c...Loop Until Completion.  RETURN Is On GET
c
      GO TO 110
      END
