      SUBROUTINE  fakestats(iter,itmax,ir,irmax)
c
c...Assemble Statistics By Magnitude Bin
c
      INCLUDE
     *            'mujfoe.inc'
      PARAMETER
     *            binmin = 5.0,
     *            binwid = 0.5
      INTEGER
     *            iter, itmax, ir, irmax, i, jj, b, j, good,
     *            ai(NRADMAX), bi(NRADMAX), test
      REAL
     *            mag, aw, bw, asum(NRADMAX), bsum(NRADMAX),
     *            ap(NUMBIN,NRADMAX), bp(NUMBIN,NRADMAX),
     *            mm(NUMBIN)
c
 9001 FORMAT (' Cannot Open STATS.OUT')
 9002 FORMAT (3i10, ' >>', a, '<<')
 9003 FORMAT (f10.2, 12f10.3)
 9004 FORMAT (10x, 6('   2R=', f4.1, '   3R=', f4.1))
 9005 FORMAT (10x, 12i10)
 9006 FORMAT (7i11)
c
c...Initialize
c
  100 IF ((iter.eq.1).and.(ir.eq.1)) THEN
        DO j=1,NRADMAX
          DO i=1,NUMBIN
            abin(i,j) = 0
            bbin(i,j) = 0
          ENDDO
        ENDDO
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='delete',
     *        err=110,
     *        form='formatted',
     *        name='fake.out',
     *        status='old',
     *        unit=9
     *       )
        CLOSE (9)
  110   CONTINUE
      ENDIF
c
c...Loop Over Detections
c
      DO i=firstpair(ir),lastpair(ir)
        test = pairs(1,i)
        good = pairs(4,i)
        jj = pjf(i1hat(test),1)
        mag = 0.01*MOD(draw(jj,1),10000)
        b = (mag-BINMIN)/BINWID + 1.0
        IF ((b.ge.1).and.(b.le.NUMBIN)) THEN
          IF (good.eq.MAYBE_GOOD) THEN
            bbin(b,ir) = bbin(b,ir)+1
          ELSE
            abin(b,ir) = abin(b,ir)+1
          ENDIF
        ENDIF
      ENDDO
c
c...Exit Now If More To Come
c
      IF ((iter.ne.itmax).or.(ir.ne.irmax)) RETURN
c
c...Compute Totals
c
      DO j=1,irmax
        bsum(j) = 0.0
        asum(j) = 0.0
        DO i=1,NUMBIN
          bsum(j) = bsum(j) + bbin(i,j)
          asum(j) = asum(j) + abin(i,j)
        ENDDO
        bi(j) = bsum(j)/itmax + 0.5
        ai(j) = asum(j)/itmax + 0.5
      ENDDO
c
c...Express Output As Percent
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='stats.out',
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9002) itmax,n1hat,n2hat
      WRITE (1,9004) (rad(j),rad(j),j=1,irmax)
      WRITE (1,9005) (bi(j),ai(j),j=1,irmax)
      DO i=1,NUMBIN
        DO j=1,irmax
          bp(i,j) = 100.0*bbin(i,j)/bsum(j)
          ap(i,j) = 100.0*abin(i,j)/asum(j)
        ENDDO
        mm(i) = BINMIN + (i-0.5)*BINWID
        WRITE (1,9003) mm(i),(bp(i,j),ap(i,j),j=1,irmax)
      ENDDO
      CLOSE (1)
      RETURN
c
c...Errors
c
  200 WRITE (*,9001)
      RETURN
      END
