      SUBROUTINE  getridge(r,sply,spll,splh,spla,splb)
c
c...Look At Columns And Generate Ridge Peaks/Widths
c
c	Use 2 levels for integral probability
c
      INCLUDE
     *            'mujfoe.inc'
      PARAMETER
     *            fract = 0.0003,
     *            level1 = 0.05,
     *            level2 = 0.50
      INTEGER
     *            r, ix, iy, nx, ny, n, iz, il, ih, ia, ib
      DOUBLE PRECISION
     *            xx, yy(2*NBOXMAX), zz(2*NBOXMAX), xmn, ymn, zmn, w,
     *            test, zmx, sum, level
      DOUBLE PRECISION
     *            sply(*), spll(*), splh(*), spla(*), splb(*)
c
c...Outer Loop Is Over X
c
  100 xmn = xmin(r)
      ymn = ymin(r)
      zmn = zmin(r)
      w = wide(r)
      nx = ixmax(r)
      nspl = 0
      DO ix=1,nx
        xx = (ix-1)*w + xmn
        ny = iymax(r)
        n = 0
c
c...Assemble Array From IY/JY
c
        iy = 0
        DO n=1,ny
          iy = iy+1
          yy(iy) = ymn + (n-1)*w
          zz(iy) = iboxes(ix,n,r)
          IF (n.lt.ny) THEN
            iy = iy+1
            yy(iy) = zmn + (n-1)*w
            zz(iy) = jboxes(ix,n,r)
          ENDIF
        ENDDO
        ny = iy
c
c...Are There Enough Points To Worry About?
c
        n = 0
        DO iy=1,ny
          n = n+zz(iy)
        ENDDO
        IF ((n/2).ge.(FRACT*itotal(r))) THEN
c
c...Find Peak And Width
c
          iz = 1
          zmx = zz(iz)
          DO iy=2,ny
            IF (zz(iy).gt.zmx) THEN
              iz = iy
              zmx = zz(iy)
            ENDIF
          ENDDO
c
c...Look For -LEVEL1
c
          test = 0.5*LEVEL1*n
          sum = 0.0
          DO il=1,iz-1
            IF ((sum+zz(il)).ge.test) GO TO 110
            sum = sum+zz(il)
          ENDDO
          il = iz-1
c
c...Look For -LEVEL2
c
  110     test = 0.5*LEVEL2*n
          sum = 0.0
          DO ia=1,iz-1
            IF ((sum+zz(ia)).ge.test) GO TO 120
            sum = sum+zz(ia)
          ENDDO
          ia = iz-1
c
c...Look For +LEVEL2
c
  120     test = 0.5*LEVEL2*n
          sum = 0
          DO ib=ny,iz+1,-1
            IF ((sum+zz(ib)).ge.test) GO TO 130
            sum = sum+zz(ib)
          ENDDO
          ib = iz+1
c
c...Look For +LEVEL1
c
  130     test = 0.5*LEVEL1*n
          sum = 0.0
          DO ih=ny,iz+1,-1
            IF ((sum+zz(ih)).ge.test) GO TO 140
            sum = sum+zz(ih)
          ENDDO
          ih = iz+1
  140     CONTINUE
c
c...Add Points To The List
c
          nspl = nspl+1
          splx(nspl) = (ix-1)*w + xmn
          sply(nspl) = yy(iz)
          spll(nspl) = yy(il)
          splh(nspl) = yy(ih)
          spla(nspl) = yy(ia)
          splb(nspl) = yy(ib)
        ENDIF
c
c...End of X Loop
c
      ENDDO
      RETURN
      END
