      PROGRAM  geninven
c
c...Generate Plate Inventory File
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1000
      INTEGER
     *         uj(NMAX), sj(NMAX), sf(NMAX), sn(NMAX), box, i, j, id,
     *         nlb, line, increment
      CHARACTER*64
     *         lb
      CHARACTER*2
     *         who
c
 9001 FORMAT (i6, 1x, a, i5)
 9002 FORMAT (' Enter Box Number: ' $)
 9003 FORMAT (i2)
 9004 FORMAT (' (', i2, '/', i2.2, ')  ', a, i4.4, ': '$)
 9005 FORMAT (q, a)
 9006 FORMAT (i4)
 9007 FORMAT ('  Huh?')
 9008 FORMAT (' Plate ', a, i5.5, ': ' $)
 9009 FORMAT (q,a)
 9010 FORMAT (i5)
 9011 FORMAT (i2, 1x, i2, 3x, a, i4.4, 3x, a, i5.5)
 9012 FORMAT ('inven.', i2.2)
c
c...Open And Parse Catalog File
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possii.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NMAX
        uj(i) = 0
        sj(i) = 0
        sf(i) = 0
        sn(i) = 0
      ENDDO
  110 READ (1,9001,err=110,end=120) i,who,j
      IF (who.eq.'UJ') THEN
        uj(i) = j
      ELSEIF (who.eq.'SJ') THEN
        sj(i) = j
      ELSEIF (who.eq.'SF') THEN
        sf(i) = j
      ELSEIF (who.eq.'SN') THEN
        sn(i) = j
      ENDIF
      GO TO 110
  120 CONTINUE
c
c...Set Up This Box
c
      WRITE (*,9002)
      READ  (*,9003) box
      WRITE (lb,9012) box
      nlb = 8
      OPEN (
     *      access='append',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
c
c...Modifications For This Batch
c
      who = 'sn'
      increment = +1
      line = 1
c
c...Loop to ask user things
c
      id = 0
  130 WRITE (*,9004) box,line,who,id
      READ  (*,9005,end=200) nlb,lb
      IF (nlb.gt.0) THEN
        READ (lb(1:nlb),9006,err=140) i
        id = i
      ENDIF
      GO TO 150
  140 IF (nlb.eq.2) THEN
        who = lb(1:2)
        GO TO 130
      ELSE
        WRITE (*,9007)
        GO TO 130
      ENDIF
  150 IF (who.eq.'uj') THEN
        i = uj(id)
      ELSEIF (who.eq.'sj') THEN
        i = sj(id)
      ELSEIF (who.eq.'sf') THEN
        i = sf(id)
      ELSE
        i = sn(id)
      ENDIF
      WRITE (*,9008) who,i
      READ  (*,9009) nlb,lb
      IF (nlb.gt.0) THEN
        READ (lb(1:nlb),9010,err=130) i
      ENDIF
      WRITE (1,9011) box,line,who,id,who,i
      line = line+1
      id = id+increment
      GO TO 130
c
  200 CLOSE (1)
      CALL EXIT
      END
