      PROGRAM  oeloop
c
c...Loop Over OE Files Looking For Gradients
c
      INCLUDE
     *         'surface.inc'
      INTEGER
     *         id, err
      REAL
     *         s, sx, sy, g, gxo, gxe, gyo, gye
c
 9001 FORMAT (' Error Reading HDR File For SO', i4.4)
 9002 FORMAT (' Error Reading HDR File For SE', i4.4)
 9003 FORMAT (i4, 8x, 2f6.0)
 9004 FORMAT (i4, f6.2, f7.3, 2f6.2, 4f7.3)
 9005 FORMAT (' Working On OE', i4.4)
c
c...Open RAW File To Get List Of Processed Plates
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../autooe/taffoe.raw',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=3
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='oeloop.out',
     *      status='unknown',
     *      unit=2
     *     )
c
c...Loop Over IDs.  Process O Then E
c
  110 READ (3,9003,end=120) id,sx,sy
      WRITE (*,9005) id
      CALL reader('so',id,err)
      IF (err.ne.0) THEN
        WRITE (*,9001) id
        GO TO 110
      ENDIF
      CALL zstats
      gxo = gx
      gyo = gy
      CALL reader('se',id,err)
      IF (err.ne.0) THEN
        WRITE (*,9002) id
        GO TO 110
      ENDIF
      CALL zstats
      gxe = gx
      gye = gy
      g = MAX(gxo,gyo,gxe,gye)
      s = SQRT(sx*sx+sy*sy)
      WRITE (2,9004) id,s,g,sx,sy,gxo,gyo,gxe,gye
      GO TO 110
c
c...All Done
c
  120 CLOSE (3)
      CLOSE (2)
      CALL EXIT
      END
