      PROGRAM  count
c
c...Understand Limiting Magnitude Differences
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nbin = 25,
     *         nlook = 20,
     *         nmax = 1000*1000
      INTEGER
     *         aah(NBIN), pha(NBIN), phd(NBIN), id, i, j, n,
     *         buf(NMAX), naah, npha, nphd
      CHARACTER*4
     *         cid
      CHARACTER*3
     *         look(NLOOK)
      DATA
     *   look/'uu0', 'uu1', 'uw0', 'uw1', 'ua0', 'ua1', 'ub0', 'ub1',
     *        'uc0', 'uc1', 'ud0', 'ud1', 'ue0', 'ue1', 'uf0', 'uf1',
     *        'ug0', 'ug1', 'uh0', 'uh1'/
c
 9001 FORMAT (' Enter UJ Field: ' $)
 9002 FORMAT (q, i4)
 9003 FORMAT (i4.4)
 9004 FORMAT (i10)
 9005 FORMAT (' Cannot Find Files For ID=', i4)
 9006 FORMAT (' N=', i6, '  N(AAH)=', i6, '  N(PHA)=', i6,
     *        '  N(PHD)=', i6)
 9007 FORMAT (4i10)
c
c...Get Field
c
  100 WRITE (*,9001)
      READ  (*,9002,err=100,end=200) i,id
      IF (i.le.0) GO TO 200
      IF ((id.lt.1).or.(id.gt.894)) GO TO 100
      WRITE (cid,9003) id
c
c...Look For INF File
c
      DO i=1,nlook
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=110,
     *        form='formatted',
     *        name='/'//look(i)//'/xpmm/lists/uj'//cid//'a.inf',
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,9004) n
        CLOSE (1)
        GO TO 120
  110   CONTINUE
      ENDDO
      WRITE (*,9005) id
      GO TO 100
c
c...Initialize Histograms
c
  120 DO i=1,NBIN
        aah(i) = 0
        pha(i) = 0
        phd(i) = 0
      ENDDO
c
c...Read PHD
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='/uz6/xpmm/dgmphd/uj'//cid//'.phd',
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (buf(i),i=1,n)
      CLOSE (1)
      DO i=1,n
        j = buf(i)/100
        IF ((j.gt.0).and.(j.lt.NBIN)) THEN
          phd(j) = phd(j)+1
        ENDIF
      ENDDO
c
c...Read PHA
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='/uz6/xpmm/dgmpha/uj'//cid//'.phd',
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (buf(i),i=1,n)
      CLOSE (1)
      DO i=1,n
        j = buf(i)/100
        IF ((j.gt.0).and.(j.le.NBIN)) THEN
          pha(j) = pha(j)+1
        ENDIF
      ENDDO
c
c...Read AAH Files
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='/uy6/xpmm/auxphd/uj'//cid//'.phd',
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (buf(i),i=1,n)
      CLOSE (1)
      DO i=1,n
        j = buf(i)/100
        IF ((j.ge.0).and.(j.le.NBIN)) THEN
          aah(j) = aah(j)+1
        ENDIF
      ENDDO
c
c...Count And Tell User
c
      naah = 0
      npha = 0
      nphd = 0
      DO i=1,NBIN
        naah = naah + aah(i)
        npha = npha + pha(i)
        nphd = nphd + phd(i)
      ENDDO
      WRITE (*,9006) n,naah,npha,nphd
      DO i=1,NBIN
        IF ((aah(i).ne.0).or.(pha(i).ne.0).or.(phd(i).ne.0)) THEN
          WRITE (*,9007) i,aah(i),pha(i),phd(i)
        ENDIF
      ENDDO
      GO TO 100
c
c...All Done
c
  200 CALL EXIT
      END
