      SUBROUTINE  poss2load(id)
c
c...Grab Entire POSS2 Database
c
      INCLUDE
     *            'phcal.inc'
      PARAMETER
     *            wide = 4.0D00
      CHARACTER*(*)
     *            id
      DOUBLE PRECISION
     *            a, b, c, czd, x, y, z, r, d, h, e, t, twopi,
     *            dmin, dmax, rmin, rmax, degint, degoff
      INTEGER
     *            nlb, fid, i, ix, iy, j, year, month, day
      CHARACTER*132
     *            lb
      CHARACTER*3
     *            mm, mmlist(12)
      DATA
     *   mmlist/'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *          'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
c
 9001 FORMAT (q, a)
 9002 FORMAT (i4)
 9003 FORMAT (2i2, f2.0)
 9004 FORMAT (f1.0, 1x, f2.0)
 9005 FORMAT (' Fatal Error', 5(' >>', a, '<<'))
 9006 FORMAT (i2, a, i2)
 9007 FORMAT (f2.0, 1x, f2.0)
 9008 FORMAT (f3.0)
c
c...Open Catalog
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uy6/xpmm/sg5/tycho/possii.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001)
      DO i=1,NFMAX
        fra(i) = 0.0D00
        fdec(i) = 0.0D00
        fha(i) = 0.0D00
        fzd(i) = 0.0D00
        fyy(i) = 0
        fmm(i) = 0
        fdd(i) = 0
        fut(i) = 0.0D00
      ENDDO
      twopi = 8.0D00*ATAN(1.0D00)
      radian = 360.0D00/twopi
      degint = radian*3600.0D00*100.0D00
      degoff = 90.0D00*3600.0D00*100.0D00
      olatitude = 33.357
c
c...Read And Keep Only Our Entries
c
  110 READ (1,9001,err=110,end=130) nlb,lb
      IF (nlb.le.0) GO TO 110
      IF (lb(8:9).ne.id) GO TO 110
      READ (lb(3:6),9002,err=200) fid
      READ (lb(30:35),9003,err=200) ix,iy,z
      CALL sla_DTF2R(ix,iy,z, r,j)
      READ (lb(38:43),9003,err=200) ix,iy,z
      CALL sla_DAF2R(ix,iy,z, d,j)
      IF (lb(37:37).eq.'-') THEN
        d = -d
      ENDIF
      READ (lb(84:87),9004,err=200) x,y
      h = x + y/60.0D00
      IF (lb(88:88).eq.'E') THEN
        h = -h
      ENDIF
      READ (lb(24:28),9007) x,y
      READ (lb(79:81),9008) z
      t = x + y/60.0D00 + z/120.0D00
c
c...Compute Epoch
c
      READ (lb(16:22),9006,err=200) day,mm,year
      DO i=1,12
        IF (mm.eq.mmlist(i)) THEN
          month = i
          GO TO 120
        ENDIF
      ENDDO
      GO TO 200
c
c...Compute ZD
c
  120 b = 90.0D00 - olatitude
      c = 90.0D00 - d*radian
      czd = COSD(b)*COSD(c) + SIND(b)*SIND(c)*COSD(h*15.0D00)
      z = ACOSD(czd)
c
c...Copy Into Storage Buffers
c
      fra(fid) = r
      fdec(fid) = d
      fha(fid) = h
      fyy(fid) = year
      fmm(fid) = month
      fdd(fid) = day
      fzd(fid) = z
      fut(fid) = t
c
c...Figure Out The Corners Of Each Field
c
      x = WIDE/radian
      dmin = d-x
      dmax = d+x
      y = x/COS(MAX(ABS(dmin),ABS(DMAX)))
      rmin = r-y
      rmax = r+y
      IF (rmin.lt.0.0D00) THEN
        rmin = rmin+twopi
        rmax = rmax+twopi
        fwrap(fid) = 1
      ELSEIF (rmax.ge.twopi) THEN
        fwrap(fid) = 2
      ELSE
        fwrap(fid) = 0
      ENDIF
      frmin(fid) = rmin*degint
      frmax(fid) = rmax*degint
      fdmin(fid) = dmin*degint + degoff
      fdmax(fid) = dmax*degint + degoff
      GO TO 110
  130 CLOSE (1)
      RETURN
c
c...Problems
c
  200 WRITE (*,9005) lb(3:6),lb(30:35),lb(37:43),lb(84:88),lb(16:22)
      CLOSE (77)
      CALL EXIT
      END
