      SUBROUTINE  tmpcompare
c
c...Compare AMAG and BMAG Arrays
c
      INCLUDE
     *            'phcheck.inc'
      INTEGER
     *            i, na, nb, nab, status, nok, nperm(25), j, mmin, mmax,
     *            alow, ahigh, blow, bhigh, clow, chigh, numa, numb,
     *            numc, z
      DOUBLE PRECISION
     *            sxa, sxxa, sxb, sxxb, sxc, sxxc, x
c
 9001 FORMAT (i4, 2i8, 2i10, 3(i10, 2f10.2))
 9002 FORMAT (i4, ' NAB=', i8, '  NA=', i8, '  NB=', i8, '  NOK=',
     *        i8)
 9003 FORMAT (' A=', i8, f7.2, '+/-', f5.2, '  B=', i8, f7.2, '+/-',
     *        f5.2, '  C=', i8, f7.2, '+/-', f5.2)
 9004 FORMAT (2i10)
c
c...Initialization
c
  100 na = 0
      nb = 0
      nab = 0
      nok = 0
      sxa = 0.0D00
      sxb = 0.0D00
      sxc = 0.0D00
      sxxa = 0.0D00
      sxxb = 0.0D00
      sxxc = 0.0D00
      numa = 0
      numb = 0
      numc = 0
      alow  =  800
      ahigh = 1400
      blow  = minmag(field)
      bhigh = maxmag(field)
      IF (blow.le.0) THEN
        blow  =  600
        bhigh = 1600
      ENDIF
      clow  =    1
      chigh = 2499
      IF (verbose.ne.0) THEN
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='ta.'//cfield,
     *        status='unknown',
     *        unit=2
     *       )
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='tb.'//cfield,
     *        status='unknown',
     *        unit=3
     *       )
        DO i=1,25
          nperm(i) = 0
        ENDDO
      ENDIF
c
c...Loop
c
      DO i=1,ns
        IF ((amag(i).le.0).or.(amag(i).gt.2500)) THEN
          status = 1
        ELSE
          status = 0
        ENDIF
        IF ((bmag(i).le.0).or.(bmag(i).gt.2500)) THEN
          status = status+2
        ENDIF
        IF (status.eq.3) THEN
          nab = nab+1
        ELSEIF (status.eq.2) THEN
          nb = nb+1
        ELSEIF (status.eq.1) THEN
          na = na+1
        ELSE
          nok = nok+1
          z = bmag(i)
          IF ((z.ge.alow).and.(z.le.ahigh)) THEN
            numa = numa+1
            x = 0.01D00*(amag(i)-bmag(i))
            sxa = sxa + x
            sxxa = sxxa + x*x
          ENDIF
          IF ((z.ge.blow).and.(z.le.bhigh)) THEN
            numb = numb+1
            x = 0.01D00*(amag(i)-bmag(i))
            sxb = sxb + x
            sxxb = sxxb + x*x
          ENDIF
          IF ((z.ge.clow).and.(z.le.chigh)) THEN
            numc = numc+1
            x = 0.01D00*(amag(i)-bmag(i))
            sxc = sxc + x
            sxxc = sxxc + x*x
          ENDIF
          IF (verbose.ne.0) THEN
            j = amag(i)/100
            IF (nperm(j).le.10) THEN
              nperm(j) = nperm(j)+1
              WRITE (2,9004) smag(i),amag(i)
              WRITE (3,9004) smag(i),bmag(i)
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      IF (numa.gt.0) THEN
        sxa = sxa/numa
        IF (numa.gt.1) THEN
          sxxa = SQRT(sxxa/numa - sxa*sxa)
        ELSE
          sxxa = 0.0D00
        ENDIF
      ENDIF
      IF (numb.gt.0) THEN
        sxb = sxb/numb
        IF (numb.gt.1) THEN
          sxxb = SQRT(sxxb/numb - sxb*sxb)
        ELSE
          sxxb = 0.0D00
        ENDIF
      ENDIF
      IF (numc.gt.0) THEN
        sxc = sxc/numc
        IF (numc.gt.1) THEN
          sxxc = SQRT(sxxc/numc - sxc*sxc)
        ELSE
          sxxc = 0.0D00
        ENDIF
      ENDIF
      IF (verbose.eq.0) THEN
        WRITE (4,9001) field,nab,na,nb,nok,numa,sxa,sxxa,numb,sxb,sxxb,
     *                 numc,sxc,sxxc
        WRITE (*,9002) field,nab,na,nb,nok
        WRITE (*,9003) numa,sxa,sxxa,numb,sxb,sxxb,numc,sxc,sxxc
      ELSE
        WRITE (*,9002) field,nab,na,nb,nok
        WRITE (*,9003) numa,sxa,sxxa,numb,sxb,sxxb,numc,sxc,sxxc
        CLOSE (2)
        CLOSE (3)
      ENDIF
      RETURN
      END
